/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.intelie.pipes.types.Type;

public class MapType
extends Type<Map> {
    private static final long serialVersionUID = 1L;
    private final Type keyType;
    private final Type valueType;

    public MapType(Type keyType, Type valueType) {
        super(Map.class, "map");
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static Type getKeyType(Type type) {
        if (type == null) {
            return null;
        }
        MapType extracted = Type.extract(type, MapType.class);
        if (extracted == null) {
            return null;
        }
        return extracted.keyType();
    }

    public static Type getValueType(Type type) {
        if (type == null) {
            return null;
        }
        MapType extracted = Type.extract(type, MapType.class);
        if (extracted == null) {
            return null;
        }
        return extracted.valueType();
    }

    @Override
    public List<Type> typeChain() {
        ArrayList<Type> result = new ArrayList<Type>();
        Set<Type> chain = this.valueType.effectiveChain();
        for (Type item : chain) {
            if (this.valueType.equals(item)) continue;
            result.add(new MapType(this.keyType, item));
        }
        return result;
    }

    public Type keyType() {
        return this.keyType;
    }

    public Type valueType() {
        return this.valueType;
    }

    @Override
    public final Map cast(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        return Collections.singletonMap("value", value);
    }

    @Override
    public String displayName() {
        return this.name() + "(" + this.keyType + ", " + this.valueType + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapType that = (MapType)o;
        return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }
}

