/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Collections;
import java.util.List;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.Type;

public final class NumberType
extends Type<Double> {
    private static final long serialVersionUID = 1L;

    public NumberType() {
        super(Double.class, "number");
    }

    @Override
    public List<Type> typeChain() {
        return Collections.singletonList(Type.COMPARABLE);
    }

    @Override
    public final Double cast(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Enum) {
            return ((Enum)value).ordinal();
        }
        if (value instanceof Period) {
            return ((Period)value).estimateMillis();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return null;
    }

    @Override
    public String makeString(Object operand) {
        return operand + "#";
    }

    @Override
    public BinaryIterator newIterator() {
        return new DoubleIterator();
    }

    private static class DoubleIterator
    implements BinaryIterator {
        private long value;
        private int i;

        private DoubleIterator() {
        }

        @Override
        public boolean reset(Object value) {
            Double number = Type.NUMBER.cast(value);
            if (number == null) {
                return false;
            }
            long bits = Double.doubleToLongBits(number);
            bits ^= 0xFFFFFFFFFFFFFFFFL;
            bits ^= (bits >>> 63 & 1L) * Long.MAX_VALUE;
            for (int i = 0; i < 4; ++i) {
                this.value <<= 16;
                this.value |= bits & 0xFFFFL;
                bits >>>= 16;
            }
            this.i = -1;
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isLast() {
            return this.i + 1 >= 4;
        }

        @Override
        public boolean moveNext() {
            if (++this.i > 0) {
                this.value >>>= 16;
            }
            return this.i < 4;
        }

        @Override
        public int current() {
            return (int)(this.value & 0xFFFFL);
        }
    }
}

