/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.HashMap;
import net.intelie.pipes.types.Type;

public interface ResolverState {
    public void set(String var1, Type<?> var2);

    public Type<?> get(String var1);

    public static ResolverState empty() {
        return Empty.instance();
    }

    public static ResolverState singleton(String name, Type<?> type) {
        return new Singleton(name, type);
    }

    public static class Singleton
    implements ResolverState {
        private final String name;
        private final Type<?> type;

        public Singleton(String name, Type<?> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public void set(String name, Type<?> type) {
            throw new UnsupportedOperationException("This resolver state is read-only");
        }

        @Override
        public Type<?> get(String name) {
            if (this.name.equals(name)) {
                return this.type;
            }
            return null;
        }
    }

    public static class Empty
    implements ResolverState {
        private static Empty INSTANCE = new Empty();

        public static ResolverState instance() {
            return INSTANCE;
        }

        @Override
        public void set(String name, Type<?> type) {
            throw new UnsupportedOperationException("This resolver state is read-only");
        }

        @Override
        public Type<?> get(String name) {
            return null;
        }
    }

    public static class Map
    implements ResolverState {
        private final java.util.Map<String, Type<?>> types;

        public Map() {
            this(new HashMap());
        }

        public Map(java.util.Map<String, Type<?>> types) {
            this.types = types;
        }

        public void clear() {
            this.types.clear();
        }

        @Override
        public void set(String name, Type<?> type) {
            this.types.put(name, type);
        }

        @Override
        public Type<?> get(String name) {
            return this.types.get(name);
        }
    }
}

