/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.ConcatIterable;

public class RowFields
implements Serializable,
Iterable<FieldInfo> {
    private static final long serialVersionUID = 1L;
    private final int size;
    private final ClauseInfo timestamp;
    private final ClauseInfo group;
    private final ClauseInfo select;
    private final Map<String, Integer> indexes;
    private final String[] names;
    private final Type[] types;
    private final boolean[] ommited;
    private final int mapSize;

    public RowFields(FieldInfo ... fields) {
        this(new ClauseInfo(fields));
    }

    public RowFields(ClauseInfo select) {
        this(null, select);
    }

    public RowFields(ClauseInfo group, ClauseInfo select) {
        this(null, group, select);
    }

    public RowFields(ClauseInfo timestamp, ClauseInfo group, ClauseInfo select) {
        if (timestamp == null) {
            timestamp = new ClauseInfo(new FieldInfo[0]);
        }
        if (group == null) {
            group = new ClauseInfo(new FieldInfo[0]);
        }
        if (select == null) {
            select = new ClauseInfo(new FieldInfo[0]);
        }
        this.size = timestamp.size() + group.size() + select.size();
        this.timestamp = timestamp;
        this.group = group;
        this.select = select;
        this.indexes = new HashMap<String, Integer>();
        this.names = new String[this.size];
        this.types = new Type[this.size];
        this.ommited = new boolean[this.size];
        this.mapSize = this.addInfo(timestamp, group, select);
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private int addInfo(ClauseInfo ... clauses) {
        int i = 0;
        int mapSize = 0;
        for (ClauseInfo clause : clauses) {
            for (FieldInfo info : clause) {
                this.names[i] = info.name();
                this.types[i] = info.type();
                Integer old = this.indexes.put(this.names[i], i);
                if (old != null) {
                    this.ommited[old.intValue()] = true;
                } else {
                    ++mapSize;
                }
                ++i;
            }
        }
        return mapSize;
    }

    public Iterable<String> names() {
        return Arrays.asList(this.names);
    }

    public int indexOf(String field) {
        Integer value = this.tryParse(field);
        if (value != null) {
            return value;
        }
        value = this.indexes.get(field);
        if (value != null) {
            return value;
        }
        return -1;
    }

    private Integer tryParse(String field) {
        try {
            if (!RowFields.isNumeric(field)) {
                return null;
            }
            int value = Integer.parseInt(field);
            if (value >= 0 && value < this.size - this.timestamp.size() - this.group.size()) {
                return value + this.timestamp.size() + this.group.size();
            }
            return null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public String name(int i) {
        return this.names[i];
    }

    public Type type(int i) {
        return this.types[i];
    }

    public boolean ommited(int i) {
        return this.ommited[i];
    }

    public ClauseInfo timestamp() {
        return this.timestamp;
    }

    public ClauseInfo select() {
        return this.select;
    }

    public ClauseInfo group() {
        return this.group;
    }

    public int size() {
        return this.size;
    }

    public int mapSize() {
        return this.mapSize;
    }

    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", this.timestamp.simple());
        map.put("group", this.group.simple());
        map.put("select", this.select.simple());
        return map;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.timestamp.size() > 0) {
            builder.append(this.timestamp).append("; ");
        }
        if (this.group.size() > 0) {
            builder.append(this.group).append("; ");
        }
        return builder.append(this.select).toString();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return ConcatIterable.create(this.timestamp, this.group, this.select).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowFields)) {
            return false;
        }
        RowFields that = (RowFields)o;
        return Arrays.equals(this.types, that.types);
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }
}

