/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.Row;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public final class RowType
extends Type<Row> {
    private static final long serialVersionUID = 1L;
    private final RowFields fields;

    public RowType(RowFields fields) {
        super(Row.class, "row");
        this.fields = fields;
    }

    public static boolean hasFields(Type type) {
        return RowType.getFields(type) != null;
    }

    public static RowFields getFields(Type type) {
        if (type == null) {
            return null;
        }
        RowType extracted = Type.extract(type, RowType.class);
        if (extracted == null) {
            return null;
        }
        return extracted.fields();
    }

    public RowFields fields() {
        return this.fields;
    }

    @Override
    public List<Type> typeChain() {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add(Type.COMPARABLE);
        result.add(Type.ROW);
        if (this.fields != null) {
            Type best = this.fields.size() > 0 ? this.fields.type(0) : Type.OBJECT;
            for (FieldInfo field : this.fields) {
                best = Type.min(best, field.type());
            }
            result.add(new SeqType(best));
        } else {
            result.add(Type.SEQ);
        }
        return result;
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>(super.simple());
        if (this.fields != null) {
            map.put("fields", this.fields.simple());
        }
        return map;
    }

    @Override
    public String displayName() {
        return this.name() + "(" + (this.fields != null ? this.fields : "?") + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType that = (RowType)o;
        return Objects.equals(this.fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

