/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.OutputType;

public class TimeOutput
implements Output,
Period {
    private static final long serialVersionUID = 1L;
    private final Period period;

    public TimeOutput(Period period) {
        this.period = period;
    }

    @Override
    public OutputType type() {
        return OutputType.TIMED;
    }

    public Period period() {
        return this.period;
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.period.simple());
        map.put("type", "time");
        return map;
    }

    @Override
    public TimeOutput forceZone(ZoneId zone) {
        return new TimeOutput(this.period.forceZone(zone));
    }

    @Override
    public TimeOutput multiply(int amount) {
        return new TimeOutput(this.period.multiply(amount));
    }

    @Override
    public String toString(boolean includeOne) {
        return "every " + this.period.toString(includeOne);
    }

    public String toString() {
        return this.toString(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeOutput)) {
            return false;
        }
        TimeOutput that = (TimeOutput)o;
        return Objects.equals(this.period, that.period);
    }

    public int hashCode() {
        return Objects.hash(this.period);
    }

    @Override
    public long add(long timestamp) {
        return this.period.add(timestamp);
    }

    @Override
    public long sub(long timestamp) {
        return this.period.sub(timestamp);
    }

    @Override
    public long floor(long timestamp) {
        return this.period.floor(timestamp);
    }

    @Override
    public boolean supportsFloor() {
        return this.period.supportsFloor();
    }

    @Override
    public long estimateMillis() {
        return this.period.estimateMillis();
    }
}

