/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.intelie.pipes.HasType;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Row;
import net.intelie.pipes.generated.SimpleCharStream;
import net.intelie.pipes.generated.TypeParserCore;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.BooleanType;
import net.intelie.pipes.types.ComparableType;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.NullType;
import net.intelie.pipes.types.NumberType;
import net.intelie.pipes.types.ObjectType;
import net.intelie.pipes.types.PeriodType;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.StringType;
import net.intelie.pipes.types.TypeCovariance;
import net.intelie.pipes.types.TypeResolver;

public abstract class Type<T>
implements Serializable {
    public static final NullType NULL = new NullType();
    public static final ObjectType OBJECT = new ObjectType();
    public static final NumberType NUMBER = new NumberType();
    public static final StringType STRING = new StringType();
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final ComparableType COMPARABLE = new ComparableType();
    public static final PeriodType PERIOD = new PeriodType();
    public static final RowType ROW = new RowType(null);
    public static final SeqType SEQ = new SeqType(OBJECT);
    public static final MapType MAP = new MapType(OBJECT, OBJECT);
    private static final Type[] TYPES = new Type[]{NUMBER, STRING, BOOLEAN, PERIOD, ROW, SEQ, MAP, COMPARABLE, OBJECT};
    private static final long serialVersionUID = 1L;
    private final Class<T> javaClass;
    private final String name;
    private transient Set<Type> effectiveChain;

    public Type(Class<T> javaClass, String name) {
        this.javaClass = javaClass;
        this.name = name;
    }

    public static List<Type> all() {
        return Collections.unmodifiableList(Arrays.asList(TYPES));
    }

    public static Type fromName(String name) throws PipeException {
        return Type.fromName(name, ResolverState.empty());
    }

    public static Type fromName(String name, ResolverState state) throws PipeException {
        return Type.resolver(name).resolve(state);
    }

    public static TypeResolver resolver(String name) throws PipeException {
        try {
            return new TypeParserCore(new SimpleCharStream(new StringReader(name))).start();
        }
        catch (Throwable e) {
            throw PipeException.handle(e);
        }
    }

    public static Type<?> min(Type<?> a, Type<?> b) {
        return TypeCovariance.simplify(a, b);
    }

    public static Type<?> infer(Object value) {
        if (value instanceof Number) {
            return NUMBER;
        }
        if (value instanceof String) {
            return STRING;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof Period) {
            return PERIOD;
        }
        if (value instanceof Row) {
            return ROW;
        }
        if (value instanceof Iterable) {
            return SEQ;
        }
        if (value instanceof Map) {
            return MAP;
        }
        if (value instanceof Comparable) {
            return COMPARABLE;
        }
        return OBJECT;
    }

    public static Type inferFromClass(Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return NUMBER;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return STRING;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        if (Period.class.isAssignableFrom(clazz)) {
            return PERIOD;
        }
        if (Row.class.isAssignableFrom(clazz)) {
            return ROW;
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return SEQ;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MAP;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE;
        }
        return OBJECT;
    }

    public static <T> Type<T> inferFromClassExact(Class<T> clazz) throws PipeException {
        if (Double.class.equals(clazz)) {
            return NUMBER;
        }
        if (String.class.equals(clazz)) {
            return STRING;
        }
        if (Boolean.class.equals(clazz)) {
            return BOOLEAN;
        }
        if (Comparable.class.equals(clazz)) {
            return COMPARABLE;
        }
        if (Period.class.equals(clazz)) {
            return PERIOD;
        }
        if (Row.class.equals(clazz)) {
            return ROW;
        }
        if (Iterable.class.equals(clazz)) {
            return SEQ;
        }
        if (Map.class.equals(clazz)) {
            return MAP;
        }
        if (Object.class.equals(clazz)) {
            return OBJECT;
        }
        throw new PipeException("Cannot infer exact class equivalent to: %s", clazz);
    }

    public static <T> T extract(Type type, Class<T> clazz) {
        T result = null;
        for (Type o : type.effectiveChain()) {
            if (!clazz.isInstance(o)) continue;
            result = clazz.cast(o);
        }
        return result;
    }

    public List<Type> typeChain() {
        return Collections.emptyList();
    }

    public Set<Type> effectiveChain() {
        if (this.effectiveChain == null) {
            this.effectiveChain = this.constructEffectiveChain();
        }
        return this.effectiveChain;
    }

    private Set<Type> constructEffectiveChain() {
        LinkedHashSet<Type> set = new LinkedHashSet<Type>();
        set.add(OBJECT);
        set.addAll(this.typeChain());
        set.add(this);
        return Collections.unmodifiableSet(set);
    }

    public <Q> boolean isAssignableTo(Type<? extends Q> type) {
        return type != null && (NULL.equals(this) || Type.min(this, type).equals(type) || this.effectiveChain().contains(type));
    }

    public boolean accepts(Object expr) {
        return expr instanceof HasType && ((HasType)expr).type().isAssignableTo(this);
    }

    public Class<T> javaClass() {
        return this.javaClass;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.name;
    }

    public String makeString(Object operand) {
        return this.name() + "(" + operand + ")";
    }

    public String toString() {
        return this.displayName();
    }

    public T cast(Object value) {
        if (this.javaClass.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public BinaryIterator newIterator() {
        throw new UnsupportedOperationException(String.format((Locale)null, "Type '%s' doesn't implement binary iteration (i.e. filters).", this.name()));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    public Map<String, Object> simple() {
        return Collections.singletonMap("name", this.name);
    }
}

