/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.intelie.pipes.types.ComparableType;
import net.intelie.pipes.types.DirectTypeResolver;
import net.intelie.pipes.types.MapTypeResolver;
import net.intelie.pipes.types.MultiTypeResolver;
import net.intelie.pipes.types.ObjectType;
import net.intelie.pipes.types.RowTypeResolver;
import net.intelie.pipes.types.SeqTypeResolver;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;

public abstract class TypeContravariance {
    public static TypeResolver simplify(TypeResolver resolver) {
        if (resolver instanceof SeqTypeResolver) {
            return TypeContravariance.simplifySeq(Collections.singletonList((SeqTypeResolver)resolver));
        }
        if (resolver instanceof MapTypeResolver) {
            return TypeContravariance.simplifyMap(Collections.singletonList((MapTypeResolver)resolver));
        }
        if (resolver instanceof RowTypeResolver) {
            return TypeContravariance.simplifyRow(Collections.singletonList((RowTypeResolver)resolver), Collections.emptyList());
        }
        if (resolver instanceof MultiTypeResolver) {
            List<TypeResolver> answer = TypeContravariance.simplifyList(((MultiTypeResolver)resolver).resolvers());
            if (answer.size() == 1) {
                return answer.get(0);
            }
            return new MultiTypeResolver(answer);
        }
        return resolver;
    }

    private static List<TypeResolver> simplifyList(List<TypeResolver> resolvers) {
        HashMap<Integer, List> row = new HashMap<Integer, List>();
        ArrayList<SeqTypeResolver> seq = new ArrayList<SeqTypeResolver>();
        ArrayList<MapTypeResolver> map = new ArrayList<MapTypeResolver>();
        ArrayList<DirectTypeResolver> direct = new ArrayList<DirectTypeResolver>();
        ArrayList<TypeResolver> other = new ArrayList<TypeResolver>();
        boolean hasUntypedRow = false;
        for (TypeResolver resolver : resolvers) {
            if (resolver instanceof SeqTypeResolver) {
                seq.add((SeqTypeResolver)resolver);
                continue;
            }
            if (resolver instanceof RowTypeResolver) {
                RowTypeResolver.FieldList fields = ((RowTypeResolver)resolver).fields();
                if (fields != null) {
                    row.computeIfAbsent(fields.size(), x -> new ArrayList()).add((RowTypeResolver)resolver);
                    continue;
                }
                hasUntypedRow = true;
                continue;
            }
            if (resolver instanceof MapTypeResolver) {
                map.add((MapTypeResolver)resolver);
                continue;
            }
            if (resolver instanceof DirectTypeResolver) {
                direct.add((DirectTypeResolver)resolver);
                continue;
            }
            other.add(resolver);
        }
        ArrayList<TypeResolver> answer = new ArrayList<TypeResolver>();
        if (row.size() > 0) {
            for (List list : row.values()) {
                answer.add(TypeContravariance.simplifyRow(list, seq));
            }
        } else {
            if (seq.size() > 0) {
                answer.add(TypeContravariance.simplifySeq(seq));
            }
            if (hasUntypedRow) {
                answer.add(new RowTypeResolver(null));
            }
        }
        if (map.size() > 0) {
            answer.add(TypeContravariance.simplifyMap(map));
        }
        if (direct.size() > 0) {
            answer.addAll(TypeContravariance.simplifyDirect(direct, row.size() > 0 || hasUntypedRow, answer.size() > 0 || other.size() > 0));
        }
        for (TypeResolver resolver : other) {
            answer.add(TypeContravariance.simplify(resolver));
        }
        return answer;
    }

    private static MapTypeResolver simplifyMap(List<MapTypeResolver> list) {
        ArrayList<TypeResolver> key = new ArrayList<TypeResolver>();
        ArrayList<TypeResolver> value = new ArrayList<TypeResolver>();
        for (MapTypeResolver resolver : list) {
            key.add(resolver.key());
            value.add(resolver.value());
        }
        return new MapTypeResolver(TypeContravariance.simplify(new MultiTypeResolver(key)), TypeContravariance.simplify(new MultiTypeResolver(value)));
    }

    private static SeqTypeResolver simplifySeq(List<SeqTypeResolver> list) {
        return new SeqTypeResolver(TypeContravariance.simplify(new MultiTypeResolver(list.stream().map(SeqTypeResolver::type).collect(Collectors.toList()))));
    }

    private static RowTypeResolver simplifyRow(List<RowTypeResolver> row, List<SeqTypeResolver> seq) {
        ArrayList<RowTypeResolver.Field> timestamp = new ArrayList<RowTypeResolver.Field>();
        ArrayList<RowTypeResolver.Field> group = new ArrayList<RowTypeResolver.Field>();
        ArrayList<RowTypeResolver.Field> select = new ArrayList<RowTypeResolver.Field>();
        int i = 0;
        i = TypeContravariance.processClause(row, seq, timestamp, i, row.get(0).fields().timestamp());
        i = TypeContravariance.processClause(row, seq, group, i, row.get(0).fields().group());
        i = TypeContravariance.processClause(row, seq, select, i, row.get(0).fields().select());
        return new RowTypeResolver(new RowTypeResolver.FieldList(timestamp, group, select));
    }

    private static int processClause(List<RowTypeResolver> row, List<SeqTypeResolver> seq, List<RowTypeResolver.Field> timestamp, int i, List<RowTypeResolver.Field> originalFields) {
        for (RowTypeResolver.Field field : originalFields) {
            List<TypeResolver> answer = seq.stream().map(SeqTypeResolver::type).collect(Collectors.toList());
            for (RowTypeResolver resolver : row) {
                RowTypeResolver.Field field1 = resolver.fields().get(i);
                answer.add(field1.type());
            }
            timestamp.add(new RowTypeResolver.Field(field.name(), TypeContravariance.simplify(new MultiTypeResolver(answer))));
            ++i;
        }
        return i;
    }

    private static List<DirectTypeResolver> simplifyDirect(List<DirectTypeResolver> list, boolean hasRow, boolean hasObject) {
        boolean[] exclude = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Type aa = list.get(i).type();
            if (hasRow && aa instanceof ComparableType || hasObject && aa instanceof ObjectType) {
                exclude[i] = true;
            }
            if (exclude[i]) continue;
            for (int j = 0; j < list.size(); ++j) {
                if (i == j || exclude[j]) continue;
                Type bb = list.get(j).type();
                if (aa == null || bb == null || !aa.isAssignableTo(bb)) continue;
                exclude[j] = true;
            }
        }
        ArrayList<DirectTypeResolver> newList = new ArrayList<DirectTypeResolver>();
        for (int i = 0; i < list.size(); ++i) {
            if (exclude[i]) continue;
            newList.add(list.get(i));
        }
        return newList;
    }
}

