/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.intelie.pipes.types.ClauseInfo;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public abstract class TypeCovariance {
    public static Type<?> simplify(Type<?> a, Type<?> b) {
        if (Type.NULL.equals(a)) {
            return b;
        }
        if (Type.NULL.equals(b)) {
            return a;
        }
        RowFields fieldsA = RowType.getFields(a);
        RowFields fieldsB = RowType.getFields(b);
        if (fieldsA != null && fieldsB != null && fieldsA.size() == fieldsB.size()) {
            return TypeCovariance.minSpecialCaseRow(fieldsA, fieldsB);
        }
        SeqType seqa = Type.extract(a, SeqType.class);
        SeqType seqb = Type.extract(b, SeqType.class);
        if (seqa != null && seqb != null) {
            return new SeqType(TypeCovariance.simplify(seqa.type(), seqb.type()));
        }
        MapType mapa = Type.extract(a, MapType.class);
        MapType mapb = Type.extract(b, MapType.class);
        if (mapa != null && mapb != null) {
            return new MapType(TypeCovariance.simplify(mapa.keyType(), mapb.keyType()), TypeCovariance.simplify(mapa.valueType(), mapb.valueType()));
        }
        Set<Type> seta = a.effectiveChain();
        Set<Type> setb = b.effectiveChain();
        Type last = Type.OBJECT;
        for (Type type : seta) {
            if (!setb.contains(type)) continue;
            last = type;
        }
        return last;
    }

    private static Type minSpecialCaseRow(RowFields fieldsA, RowFields fieldsB) {
        ArrayList<FieldInfo> timestamp = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> group = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> select = new ArrayList<FieldInfo>();
        int i = 0;
        i = TypeCovariance.alignClause(i, fieldsA.timestamp(), fieldsB, timestamp);
        i = TypeCovariance.alignClause(i, fieldsA.group(), fieldsB, group);
        TypeCovariance.alignClause(i, fieldsA.select(), fieldsB, select);
        return new RowType(new RowFields(new ClauseInfo(timestamp), new ClauseInfo(group), new ClauseInfo(select)));
    }

    private static int alignClause(int i, ClauseInfo clause, RowFields fieldsB, List<FieldInfo> fields) {
        for (FieldInfo fieldInfo : clause) {
            Type other = fieldsB.type(i);
            fields.add(new FieldInfo(fieldInfo.name(), TypeCovariance.simplify(fieldInfo.type(), other)));
            ++i;
        }
        return i;
    }
}

