/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.intelie.pipes.util.Iterables;

public class ConcatIterable<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterable<? extends Iterable<? extends T>> iterables;

    public ConcatIterable(Iterable<? extends Iterable<? extends T>> iterables) {
        this.iterables = iterables;
    }

    public static <T> ConcatIterable<T> create(Iterable<T> ... iterables) {
        return new ConcatIterable<T>(Arrays.asList(iterables));
    }

    @Override
    public Iterator<T> iterator() {
        return new ConcatIterator();
    }

    public String toString() {
        return "(" + Iterables.join(" ++ ", this.iterables) + ")";
    }

    private class ConcatIterator
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Iterator<? extends Iterable<? extends T>> parent;
        private Iterator<? extends T> current;

        public ConcatIterator() {
            this.parent = ConcatIterable.this.iterables.iterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentHasNext()) {
                return true;
            }
            while (this.parent.hasNext() && !this.currentHasNext()) {
                Iterable next = this.parent.next();
                if (next == null) continue;
                this.current = next.iterator();
            }
            return this.currentHasNext();
        }

        private boolean currentHasNext() {
            return this.current != null && this.current.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }
    }
}

