/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

public abstract class DoubleUtils {
    private static final long[] POWERS_OF_TEN_LONG;
    private static final double[] POWERS_OF_TEN_DOUBLE;

    public static String format(double value) {
        StringBuilder builder = new StringBuilder();
        DoubleUtils.formatDouble(value, 6, 6, builder);
        return builder.toString();
    }

    public static void formatDouble(double source, int decimals, int precision, StringBuilder target) {
        int scale;
        int n = scale = Math.abs(source) >= 1.0 ? decimals : precision;
        if (DoubleUtils.tooManyDigitsUsed(source, scale) || DoubleUtils.tooCloseToRound(source, scale)) {
            DoubleUtils.formatDoublePrecise(source, decimals, precision, target);
        } else {
            DoubleUtils.formatDoubleFast(source, decimals, precision, target);
        }
    }

    public static void formatDoublePrecise(double source, int decimals, int precision, StringBuilder target) {
        boolean negative;
        if (DoubleUtils.isRoundedToZero(source, decimals, precision)) {
            target.append('0');
            return;
        }
        if (Double.isNaN(source) || Double.isInfinite(source)) {
            target.append(Double.toString(source));
            return;
        }
        boolean bl = negative = source < 0.0;
        if (negative) {
            source = -source;
            target.append('-');
        }
        int scale = source >= 1.0 ? decimals : precision;
        String s = Double.toString(source);
        if (source >= 0.001 && source < 1.0E7) {
            int dot = s.indexOf(46);
            String decS = s.substring(dot + 1);
            int decLength = decS.length();
            if (scale >= decLength) {
                if ("0".equals(decS)) {
                    target.append(s.substring(0, dot));
                } else {
                    target.append(s);
                    DoubleUtils.removeTrailingZeroes(target);
                }
                return;
            }
            if (scale + 1 < decLength) {
                decLength = scale + 1;
                decS = decS.substring(0, decLength);
            }
            long intP = Long.parseLong(s.substring(0, dot));
            long decP = Long.parseLong(decS);
            DoubleUtils.format(target, scale, intP, decP);
        } else {
            int dot = s.indexOf(46);
            assert (dot >= 0);
            int exp = s.indexOf(69);
            assert (exp >= 0);
            int exposant = Integer.parseInt(s.substring(exp + 1));
            String intS = s.substring(0, dot);
            String decS = s.substring(dot + 1, exp);
            int decLength = decS.length();
            if (exposant >= 0) {
                int digits = decLength - exposant;
                if (digits <= 0) {
                    target.append(intS);
                    target.append(decS);
                    for (int i = -digits; i > 0; --i) {
                        target.append('0');
                    }
                } else if (digits <= scale) {
                    target.append(intS);
                    target.append(decS.substring(0, exposant));
                    target.append('.');
                    target.append(decS.substring(exposant));
                } else {
                    long intP = Long.parseLong(intS) * DoubleUtils.tenPow(exposant) + Long.parseLong(decS.substring(0, exposant));
                    long decP = Long.parseLong(decS.substring(exposant, exposant + scale + 1));
                    DoubleUtils.format(target, scale, intP, decP);
                }
            } else {
                int digits = scale - (exposant = -exposant) + 1;
                if (!DoubleUtils.appendZero(digits < 0, target)) {
                    if (digits == 0) {
                        long decP = Long.parseLong(intS);
                        DoubleUtils.format(target, scale, 0L, decP);
                    } else if (decLength < digits) {
                        long decP = Long.parseLong(intS) * DoubleUtils.tenPow(decLength + 1) + Long.parseLong(decS) * 10L;
                        DoubleUtils.format(target, exposant + decLength, 0L, decP);
                    } else {
                        long subDecP = Long.parseLong(decS.substring(0, digits));
                        long decP = Long.parseLong(intS) * DoubleUtils.tenPow(digits) + subDecP;
                        DoubleUtils.format(target, scale, 0L, decP);
                    }
                }
            }
        }
    }

    public static boolean appendZero(boolean condition, StringBuilder target) {
        if (condition) {
            target.append('0');
        }
        return condition;
    }

    public static void removeTrailingZeroes(StringBuilder target) {
        for (int l = target.length() - 1; l >= 0 && target.charAt(l) == '0'; --l) {
            target.setLength(l);
        }
    }

    private static boolean isRoundedToZero(double source, int decimals, int precision) {
        return source == 0.0 || Math.abs(source) < 4.999999999999999 / DoubleUtils.tenPowDouble(Math.max(decimals, precision) + 1);
    }

    public static long tenPow(int n) {
        assert (n >= 0);
        return n < POWERS_OF_TEN_LONG.length ? POWERS_OF_TEN_LONG[n] : (long)Math.pow(10.0, n);
    }

    private static double tenPowDouble(int n) {
        assert (n >= 0);
        return n < POWERS_OF_TEN_DOUBLE.length ? POWERS_OF_TEN_DOUBLE[n] : Math.pow(10.0, n);
    }

    private static void format(StringBuilder target, int scale, long intP, long decP) {
        if (decP != 0L) {
            decP += 5L;
            if ((double)(decP /= 10L) >= DoubleUtils.tenPowDouble(scale)) {
                ++intP;
                decP -= DoubleUtils.tenPow(scale);
            }
            if (decP != 0L) {
                while (decP % 10L == 0L) {
                    decP /= 10L;
                    --scale;
                }
            }
        }
        target.append(intP);
        if (decP != 0L) {
            target.append('.');
            while (scale > 0 && (scale > 18 ? (double)decP < DoubleUtils.tenPowDouble(--scale) : decP < DoubleUtils.tenPow(--scale))) {
                target.append('0');
            }
            target.append(decP);
        }
    }

    public static void formatDoubleFast(double source, int decimals, int precision, StringBuilder target) {
        double tenScale;
        if (DoubleUtils.isRoundedToZero(source, decimals, precision)) {
            target.append('0');
            return;
        }
        if (Double.isNaN(source) || Double.isInfinite(source)) {
            target.append(Double.toString(source));
            return;
        }
        boolean isPositive = source >= 0.0;
        source = Math.abs(source);
        int scale = source >= 1.0 ? decimals : precision;
        long intPart = (long)Math.floor(source);
        double fracUnroundedPart = (source - (double)intPart) * (tenScale = DoubleUtils.tenPowDouble(scale));
        long fracPart = Math.round(fracUnroundedPart);
        if ((double)fracPart >= tenScale) {
            ++intPart;
            fracPart = Math.round((double)fracPart - tenScale);
        }
        if (fracPart != 0L) {
            while (fracPart % 10L == 0L) {
                fracPart /= 10L;
                --scale;
            }
        }
        if (!DoubleUtils.appendZero(intPart == 0L && fracPart == 0L, target)) {
            if (!isPositive) {
                target.append('-');
            }
            target.append(intPart);
            if (fracPart != 0L) {
                target.append('.');
                while (scale > 0 && (double)fracPart < DoubleUtils.tenPowDouble(--scale)) {
                    target.append('0');
                }
                target.append(fracPart);
            }
        }
    }

    private static boolean tooManyDigitsUsed(double source, int scale) {
        double decExp = Math.log10(source);
        return scale >= 308 || decExp + (double)scale >= 14.5;
    }

    private static boolean tooCloseToRound(double source, int scale) {
        source = Math.abs(source);
        long intPart = (long)Math.floor(source);
        double fracPart = (source - (double)intPart) * DoubleUtils.tenPowDouble(scale);
        double decExp = Math.log10(source);
        double range = decExp + (double)scale >= 12.0 ? 0.1 : 0.001;
        double distanceToRound1 = Math.abs(fracPart - Math.floor(fracPart));
        double distanceToRound2 = Math.abs(fracPart - Math.floor(fracPart) - 0.5);
        return distanceToRound1 <= range || distanceToRound2 <= range;
    }

    static {
        int i;
        POWERS_OF_TEN_LONG = new long[19];
        POWERS_OF_TEN_DOUBLE = new double[30];
        DoubleUtils.POWERS_OF_TEN_LONG[0] = 1L;
        for (i = 1; i < POWERS_OF_TEN_LONG.length; ++i) {
            DoubleUtils.POWERS_OF_TEN_LONG[i] = POWERS_OF_TEN_LONG[i - 1] * 10L;
        }
        for (i = 0; i < POWERS_OF_TEN_DOUBLE.length; ++i) {
            DoubleUtils.POWERS_OF_TEN_DOUBLE[i] = Double.parseDouble("1e" + i);
        }
    }
}

