/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.intelie.pipes.filters.Segment;

public abstract class Escapes {
    public static final Pattern DIACRITICS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    public static final char[] BACKSLASH = new char[]{'\'', '\\'};
    public static final char[] BRACES = new char[]{'{', '}'};
    private static final char[] ID_FORBIDDEN = new char[]{' ', '\n', '\t', '\r', '\u3000', '#', '$', ',', '+', '-', '!', '(', ')', ':', '^', '[', ']', '\"', '\'', '{', '}', '~', '*', '?', '\\', '/', '%', '>', '<', '=', '@', '&', '|'};
    private static final Pattern FLAT = Pattern.compile("[^\\w]+");
    private static final Pattern DUPLICATED = Pattern.compile("[_]+");

    public static Segment[] unescapeWildcard(String input) {
        return Escapes.unescapeWildcard(input, true);
    }

    public static Segment[] unescapeWildcard(String input, boolean acceptMoreThanOne) {
        if (input == null) {
            return null;
        }
        ArrayList<Segment> result = new ArrayList<Segment>();
        StringBuilder builder = new StringBuilder(input.length());
        boolean escaping = false;
        int multiplier = 0;
        int code = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (multiplier > 0) {
                code += Character.digit(c, 16) * multiplier;
                if ((multiplier /= 16) != 0) continue;
                builder.appendCodePoint(code);
                code = 0;
                continue;
            }
            if (escaping) {
                if (c == 'u') {
                    multiplier = 4096;
                } else if (c == 'x') {
                    multiplier = 16;
                } else if (c == 'n') {
                    builder.append('\n');
                } else if (c == 't') {
                    builder.append('\t');
                } else if (c == 'r') {
                    builder.append('\r');
                } else {
                    builder.append(c);
                }
                escaping = false;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            if (c == '*' && acceptMoreThanOne) {
                if (builder.length() > 0) {
                    result.add(new Segment.Literal(builder.toString()));
                }
                result.add(new Segment.Star());
                builder.setLength(0);
                continue;
            }
            if (c == '?' && acceptMoreThanOne) {
                if (builder.length() > 0) {
                    result.add(new Segment.Literal(builder.toString()));
                }
                result.add(new Segment.Question());
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (multiplier > 0) {
            throw new IllegalArgumentException("Truncated unicode escape sequence.");
        }
        if (escaping) {
            throw new IllegalArgumentException("Term can not end with escape character.");
        }
        if (builder.length() > 0 || result.size() == 0) {
            result.add(new Segment.Literal(builder.toString()));
        }
        return result.toArray(new Segment[result.size()]);
    }

    public static String unescape(String input) {
        Segment[] result = Escapes.unescapeWildcard(input, false);
        if (result == null) {
            return null;
        }
        assert (result.length == 1 && result[0] instanceof Segment.Literal);
        return (String)((Segment.Literal)result[0]).value();
    }

    public static String formatString(String s) {
        return "'" + Escapes.escapeInternal(s, BACKSLASH) + "'";
    }

    public static String formatIdentifier(String s) {
        String s2 = Escapes.escapeInternal(s, BRACES);
        if (s2.length() != s.length() || Escapes.needsIdentifierFormatting(s)) {
            return "{" + s2 + "}";
        }
        return s;
    }

    public static String formatUnquotedString(String s) {
        return Escapes.escapeInternal(s, ID_FORBIDDEN);
    }

    public static String safeIdentifier(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = DIACRITICS.matcher(s).replaceAll("");
        s = FLAT.matcher(s).replaceAll("_");
        s = DUPLICATED.matcher(s).replaceAll("_");
        if ((s = Escapes.trimUnderscore(s)).length() == 0) {
            return "__";
        }
        if (Character.isDigit(s.charAt(0))) {
            return "_" + s;
        }
        return s;
    }

    private static String trimUnderscore(String s) {
        int j;
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == '_'; ++i) {
        }
        for (j = s.length(); j > 0 && s.charAt(j - 1) == '_'; --j) {
        }
        if (i > j) {
            return "";
        }
        return s.substring(i, j);
    }

    public static boolean needsIdentifierFormatting(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Arrays.binarySearch(ID_FORBIDDEN, c) >= 0) {
                return true;
            }
            if (Character.isDigit(c) && i == 0) {
                return true;
            }
            if (c != '@' || i == 0) continue;
            return true;
        }
        return false;
    }

    public static String escape(String s) {
        return Escapes.escapeInternal(s, new char[0]);
    }

    private static String escapeInternal(String s, char ... escapeChars) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c >= '\u0100') {
                sb.append("\\u").append(Escapes.hex(c, 4));
                continue;
            }
            if (c <= '\u001f' || c >= '\u0080') {
                sb.append("\\x").append(Escapes.hex(c, 2));
                continue;
            }
            if (Arrays.binarySearch(escapeChars, c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String hex(char c, int size) {
        StringBuilder sb = new StringBuilder();
        String s = Integer.toString(c, 16);
        for (int i = s.length(); i < size; ++i) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    static {
        Arrays.sort(ID_FORBIDDEN);
        Arrays.sort(BACKSLASH);
        Arrays.sort(BRACES);
    }
}

