/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;

public abstract class Iterables {
    public static <T> boolean equals(Iterable<T> a, Iterable<T> b) {
        Iterator<T> ita = a.iterator();
        Iterator<T> itb = b.iterator();
        while (ita.hasNext() && itb.hasNext()) {
            if (Objects.equals(ita.next(), itb.next())) continue;
            return false;
        }
        return !ita.hasNext() && !itb.hasNext();
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        for (Object ignored : iterable) {
            ++size;
        }
        return size;
    }

    public static <T> boolean sameElements(Iterable<T> a, Iterable<T> b) {
        class Count {
            int count = 0;

            Count() {
            }
        }
        Count count;
        HashMap<T, Count> map = new HashMap<T, Count>();
        for (T obj : a) {
            count = (Count)map.get(obj);
            if (count == null) {
                count = new Count();
                map.put(obj, count);
            }
            ++count.count;
        }
        for (T obj : b) {
            count = (Count)map.get(obj);
            if (count == null) {
                return false;
            }
            if (--count.count != 0) continue;
            map.remove(obj);
        }
        return map.size() == 0;
    }

    public static String join(String separator, Object[] iterable) {
        return Iterables.join(separator, Arrays.asList(iterable));
    }

    public static String join(String separator, Iterable<?> iterable) {
        return Iterables.joinWithLast(separator, separator, iterable);
    }

    public static String joinWithLast(String separator, String lastSeparator, Iterable<?> iterable) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator = iterable.iterator();
        boolean first = true;
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object obj = iterator.next();
            hasNext = iterator.hasNext();
            if (!first) {
                builder.append(hasNext ? separator : lastSeparator);
            }
            if (obj != null) {
                builder.append(obj);
            }
            first = false;
        }
        return builder.toString();
    }

    public static int hash(Iterable<?> iterable) {
        int result = 0;
        for (Object obj : iterable) {
            result *= 31;
            result ^= obj != null ? obj.hashCode() : 0;
        }
        return result;
    }

    public static boolean isEmpty(Iterable<?> properties) {
        return !properties.iterator().hasNext();
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            return defaultValue;
        }
        return it.next();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> clazz) {
        ArrayList list = new ArrayList();
        Iterables.addAll(list, iterable);
        Object[] arr = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(arr);
        return arr;
    }

    public static <T> void addAll(Collection<T> list, Iterable<? extends T> iterable) {
        for (T obj : iterable) {
            list.add(obj);
        }
    }
}

