/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.intelie.pipes.Row;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.Type;

public class MapRow
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RowFields fields;
    private final Row row;

    public MapRow(RowFields fields, Row row) {
        this.fields = fields;
        this.row = row;
    }

    public static Object getCasted(Type type, Object value) {
        if (RowType.hasFields(type) && value instanceof Row) {
            return new MapRow(RowType.getFields(type), (Row)value);
        }
        if (type.isAssignableTo(Type.SEQ) && value instanceof Iterable) {
            ArrayList<Object> list = new ArrayList<Object>();
            Type inner = Type.extract(type, SeqType.class).type();
            for (Object o : (Iterable)value) {
                list.add(MapRow.getCasted(inner, o));
            }
            return list;
        }
        if (type.isAssignableTo(Type.MAP) && value instanceof Map) {
            Type keyType = MapType.getKeyType(type);
            Type valueType = MapType.getValueType(type);
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                map.put(MapRow.getCasted(keyType, entry.getKey()), MapRow.getCasted(valueType, entry.getValue()));
            }
            return map;
        }
        return type.cast(value);
    }

    public Row row() {
        return this.row;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        int i = this.fields.indexOf((String)key);
        return this.getCasted(i);
    }

    private Object getCasted(int i) {
        if (i < 0 || i >= this.row.size()) {
            return null;
        }
        Object value = this.row.get(i);
        Type type = this.fields.type(i);
        return MapRow.getCasted(type, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.fields.indexOf((String)key) >= 0;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, Object>> {
        private int i = -1;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            this.ignoreOmmited();
            return this.i + 1 < MapRow.this.fields.size();
        }

        private void ignoreOmmited() {
            while (this.i + 1 < MapRow.this.fields.size() && MapRow.this.fields.ommited(this.i + 1)) {
                ++this.i;
            }
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.ignoreOmmited();
            ++this.i;
            return new AbstractMap.SimpleImmutableEntry<String, Object>(MapRow.this.fields.name(this.i), MapRow.this.getCasted(this.i));
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object value = MapRow.this.get(((Map.Entry)o).getKey());
            return Objects.equals(value, ((Map.Entry)o).getValue());
        }

        @Override
        public int size() {
            return MapRow.this.fields.mapSize();
        }
    }
}

