/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MergedMap<K, V>
extends AbstractMap<K, V> {
    private final HashMap<Object, V> cache = new HashMap();
    private final List<Map<K, V>> maps;
    private Set<K> keys = null;

    public MergedMap(List<Map<K, V>> maps) {
        this.maps = maps;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            Set set = this.maps.stream().flatMap(x -> x.keySet().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            this.keys = Collections.unmodifiableSet(set);
        }
        return this.keys;
    }

    @Override
    public V get(Object key) {
        V value = this.cache.get(key);
        if (value != null || this.cache.containsKey(key)) {
            return value;
        }
        int i = this.maps.size();
        while (--i >= 0) {
            Map<K, V> map = this.maps.get(i);
            value = map.get(key);
            if (value == null && !map.containsKey(key)) continue;
            this.cache.put(key, value);
            return value;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cache.containsKey(key)) {
            return true;
        }
        int i = this.maps.size();
        while (--i >= 0) {
            Map<K, V> map = this.maps.get(i);
            if (!map.containsKey(key)) continue;
            this.cache.put(key, map.get(key));
            return true;
        }
        return false;
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<K> it;

        private EntryIterator() {
            this.it = MergedMap.this.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = this.it.next();
            return new AbstractMap.SimpleImmutableEntry(key, MergedMap.this.get(key));
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object value = MergedMap.this.get(((Map.Entry)o).getKey());
            return Objects.equals(value, ((Map.Entry)o).getValue());
        }

        @Override
        public int size() {
            return MergedMap.this.keySet().size();
        }
    }
}

