/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.intelie.pipes.util.SafeCloseable;

public class ObjectPool<T> {
    private final ConcurrentLinkedQueue<Ref> queue = new ConcurrentLinkedQueue();
    private final Supplier<T> factory;
    private final int maxRetries;
    private final List<T> strong;

    public ObjectPool(Supplier<T> factory) {
        this(factory, 1, 5);
    }

    public ObjectPool(Supplier<T> factory, int minPoolSize, int maxRetries) {
        this.maxRetries = maxRetries;
        this.factory = factory;
        this.strong = this.initMinPool(factory, minPoolSize);
    }

    private List<T> initMinPool(Supplier<T> factory, int minPoolSize) {
        ArrayList strong = new ArrayList();
        for (int i = 0; i < minPoolSize; ++i) {
            try (Ref ref = new Ref(factory.get());){
                strong.add(ref.obj());
                continue;
            }
        }
        return strong;
    }

    public Ref acquire() {
        Ref ref = null;
        for (int i = 0; i < this.maxRetries && (ref = this.queue.poll()) != null && !ref.materialize(); ++i) {
            ref = null;
        }
        if (ref == null) {
            ref = new Ref(this.factory.get());
        }
        return ref;
    }

    public class Ref
    implements SafeCloseable {
        private final WeakReference<T> ref;
        private T obj;

        private Ref(T obj) {
            this.ref = new WeakReference(obj);
            this.obj = obj;
        }

        private boolean materialize() {
            this.obj = this.ref.get();
            return this.obj != null;
        }

        public T obj() {
            return this.obj;
        }

        @Override
        public void close() {
            if (this.obj == null) {
                return;
            }
            this.obj = null;
            ObjectPool.this.queue.offer(this);
        }
    }
}

