/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.violations.UseOfNonEquivalentClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSuperClassExpression;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2RLProfile
implements OWLProfile {
    protected static final Set<IRI> ALLOWED_DATATYPES = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_NON_POSITIVE_INTEGER.getIRI(), OWL2Datatype.XSD_POSITIVE_INTEGER.getIRI(), OWL2Datatype.XSD_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_LONG.getIRI(), OWL2Datatype.XSD_INT.getIRI(), OWL2Datatype.XSD_SHORT.getIRI(), OWL2Datatype.XSD_BYTE.getIRI(), OWL2Datatype.XSD_UNSIGNED_LONG.getIRI(), OWL2Datatype.XSD_UNSIGNED_BYTE.getIRI(), OWL2Datatype.XSD_FLOAT.getIRI(), OWL2Datatype.XSD_DOUBLE.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_LANGUAGE.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_BOOLEAN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));
    @Nonnull
    private final OWL2RLSubClassExpressionChecker subClassExpressionChecker = new OWL2RLSubClassExpressionChecker();
    @Nonnull
    private final OWL2RLSuperClassExpressionChecker superClassExpressionChecker = new OWL2RLSuperClassExpressionChecker();
    @Nonnull
    private final OWL2RLEquivalentClassExpressionChecker equivalentClassExpressionChecker = new OWL2RLEquivalentClassExpressionChecker();

    @Nonnull
    static Boolean b(boolean b) {
        return b;
    }

    @Override
    public String getName() {
        return "OWL 2 RL";
    }

    @Override
    @Nonnull
    public IRI getIRI() {
        return Profiles.OWL2_RL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.getImportsClosure());
        OWL2RLObjectVisitor visitor = new OWL2RLObjectVisitor(walker);
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected boolean isOWL2RLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(this.subClassExpressionChecker);
    }

    public boolean isOWL2RLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(this.superClassExpressionChecker);
    }

    public boolean isOWL2RLEquivalentClassExpression(OWLClassExpression ce) {
        return ce.accept(this.equivalentClassExpressionChecker);
    }

    private static class OWL2RLEquivalentClassExpressionChecker
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        OWL2RLEquivalentClassExpressionChecker() {
            super(OWL2RLProfile.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return OWL2RLProfile.b(!ce.isOWLThing());
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression e : ce.getOperands()) {
                if (e.accept(this).booleanValue()) continue;
                return OWL2RLProfile.b(false);
            }
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return OWL2RLProfile.b(true);
        }
    }

    private class OWL2RLSuperClassExpressionChecker
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        OWL2RLSuperClassExpressionChecker() {
            super(OWL2RLProfile.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return OWL2RLProfile.b(!ce.isOWLThing());
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression e : ce.getOperands()) {
                if (e.accept(this).booleanValue()) continue;
                return OWL2RLProfile.b(false);
            }
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return OWL2RLProfile.b(OWL2RLProfile.this.isOWL2RLSubClassExpression(ce.getOperand()));
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality ce) {
            return OWL2RLProfile.b(!(ce.getCardinality() != 0 && ce.getCardinality() != 1 || !((OWLClassExpression)ce.getFiller()).isOWLThing() && !OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller())));
        }

        @Override
        public Boolean visit(OWLDataAllValuesFrom ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLDataMaxCardinality ce) {
            return OWL2RLProfile.b(ce.getCardinality() == 0 || ce.getCardinality() == 1);
        }
    }

    private class OWL2RLSubClassExpressionChecker
    extends OWLClassExpressionVisitorExAdapter<Boolean> {
        OWL2RLSubClassExpressionChecker() {
            super(OWL2RLProfile.b(false));
        }

        @Override
        public Boolean visit(OWLClass ce) {
            return OWL2RLProfile.b(!ce.isOWLThing());
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression op : ce.getOperands()) {
                if (OWL2RLProfile.this.isOWL2RLSubClassExpression(op)) continue;
                return OWL2RLProfile.b(false);
            }
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectUnionOf ce) {
            for (OWLClassExpression op : ce.getOperands()) {
                if (OWL2RLProfile.this.isOWL2RLSubClassExpression(op)) continue;
                return OWL2RLProfile.b(false);
            }
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return OWL2RLProfile.b(((OWLClassExpression)ce.getFiller()).isOWLThing() || OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller()));
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLObjectOneOf ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return OWL2RLProfile.b(true);
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return OWL2RLProfile.b(true);
        }
    }

    private class OWL2RLObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private final Set<OWLProfileViolation> violations;

        OWL2RLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.violations = new HashSet<OWLProfileViolation>();
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.violations);
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getClassExpression())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                assert (ce != null);
                if (OWL2RLProfile.this.isOWL2RLEquivalentClassExpression(ce)) continue;
                this.violations.add(new UseOfNonEquivalentClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getClassExpression())) {
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getDomain())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getRange()));
            }
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getSubClass())) {
                this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSubClass()));
            }
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getSuperClass())) {
                this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSuperClass()));
            }
        }

        @Override
        public void visit(SWRLRule rule) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
        }

        @Override
        public void visit(OWLDataIntersectionOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataOneOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataComplementOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDatatype node) {
            if (!ALLOWED_DATATYPES.contains(node.getIRI())) {
                this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDataUnionOf node) {
            this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }
}

