/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.renderer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class TurtleRenderer
extends RDFRendererBase {
    private final PrintWriter writer;
    private final PrefixManager pm;
    private final Set<RDFResource> pending;
    private final String base;
    private final OWLDocumentFormat format;
    int bufferLength = 0;
    int lastNewLineIndex = 0;
    @Nonnull
    final Stack<Integer> tabs = new Stack();
    int level = 0;

    public TurtleRenderer(@Nonnull OWLOntology ontology, Writer writer, OWLDocumentFormat format) {
        super(ontology, format);
        this.format = OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        this.writer = new PrintWriter(writer);
        this.pending = new HashSet<RDFResource>();
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous()) {
            String ontologyIRIString;
            String defaultPrefix = ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (!ontologyIRIString.endsWith("/")) {
                defaultPrefix = ontologyIRIString + '#';
            }
            this.pm.setDefaultPrefix(defaultPrefix);
        }
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)format;
            this.pm.copyPrefixesFrom(prefixFormat);
            this.pm.setPrefixComparator(prefixFormat.getPrefixComparator());
        }
        this.base = "";
    }

    private void writeNamespaces() {
        for (Map.Entry<String, String> e : this.pm.getPrefixName2PrefixMap().entrySet()) {
            this.write("@prefix ");
            this.write(e.getKey());
            this.write(" ");
            this.writeAsURI(e.getValue());
            this.write(" .");
            this.writeNewLine();
        }
    }

    protected void pushTab() {
        this.tabs.push(this.getIndent());
    }

    protected void popTab() {
        if (!this.tabs.isEmpty()) {
            this.tabs.pop();
        }
    }

    private void write(@Nonnull String s) {
        int newLineIndex = s.indexOf(10);
        if (newLineIndex != -1) {
            this.lastNewLineIndex = this.bufferLength + newLineIndex;
        }
        this.writer.write(s);
        this.bufferLength += s.length();
    }

    private int getCurrentPos() {
        return this.bufferLength;
    }

    private int getIndent() {
        return this.getCurrentPos() - this.lastNewLineIndex;
    }

    private void writeAsURI(@Nonnull String s) {
        this.write("<");
        if (s.startsWith(this.base)) {
            this.write(s.substring(this.base.length()));
        } else {
            this.write(s);
        }
        this.write(">");
    }

    private void write(@Nonnull IRI iri) {
        if (iri.equals(this.ontology.getOntologyID().getOntologyIRI().orNull())) {
            this.writeAsURI(iri.toString());
        } else {
            String name = this.pm.getPrefixIRI(iri);
            if (name == null) {
                this.writeAsURI(iri.toString());
            } else if (name.indexOf(58) != -1) {
                this.write(name);
            } else {
                this.write(":");
                this.write(name);
            }
        }
    }

    private void writeNewLine() {
        this.write("\n");
        int tabIndent = 0;
        if (!this.tabs.isEmpty()) {
            tabIndent = this.tabs.peek();
        }
        for (int i = 1; i < tabIndent; ++i) {
            this.write(" ");
        }
    }

    private void write(@Nonnull RDFNode node) {
        if (node.isLiteral()) {
            this.write((RDFLiteral)node);
        } else {
            this.write((RDFResource)node);
        }
    }

    private void write(@Nonnull RDFLiteral node) {
        if (!node.isPlainLiteral()) {
            if (node.getDatatype().equals(XSDVocabulary.INTEGER.getIRI())) {
                this.write(node.getLexicalValue());
            } else if (node.getDatatype().equals(XSDVocabulary.DECIMAL.getIRI())) {
                this.write(node.getLexicalValue());
            } else {
                this.writeStringLiteral(node.getLexicalValue());
                this.write("^^");
                this.write(node.getDatatype());
            }
        } else {
            this.writeStringLiteral(node.getLexicalValue());
            if (node.hasLang()) {
                this.write("@");
                this.write(node.getLang());
            }
        }
    }

    private void writeStringLiteral(@Nonnull String literal) {
        String escapedLiteral = EscapeUtils.escapeString(literal);
        if (escapedLiteral.indexOf(10) != -1) {
            this.write("\"\"\"");
            this.write(escapedLiteral);
            this.write("\"\"\"");
        } else {
            this.write("\"");
            this.write(escapedLiteral);
            this.write("\"");
        }
    }

    private void write(@Nonnull RDFResource node) {
        if (!node.isAnonymous()) {
            this.write(node.getIRI());
        } else {
            this.pushTab();
            if (!this.isObjectList(node)) {
                this.render(node);
            } else {
                ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                this.toJavaList(node, list);
                this.pushTab();
                this.write("(");
                this.write(" ");
                this.pushTab();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.write((RDFNode)OWLAPIPreconditions.verifyNotNull(it.next()));
                    if (!it.hasNext()) continue;
                    this.writeNewLine();
                }
                this.popTab();
                this.writeNewLine();
                this.write(")");
                this.popTab();
            }
            this.popTab();
        }
    }

    @Override
    protected void beginDocument() {
        this.writeNamespaces();
        this.write("@base ");
        this.write("<");
        if (!this.ontology.isAnonymous()) {
            this.write(((IRI)this.ontology.getOntologyID().getOntologyIRI().get()).toString());
        } else {
            this.write(Namespaces.OWL.toString());
        }
        this.write("> .");
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void endDocument() {
        this.writer.flush();
        this.writer.println();
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (!this.format.isAddMissingTypes()) {
            this.writeComment("Warning: type declarations were not added automatically.");
        }
        this.writer.flush();
    }

    @Override
    protected void writeClassComment(@Nonnull OWLClass cls) {
        this.writeComment(cls.getIRI().toString());
    }

    @Override
    protected void writeObjectPropertyComment(@Nonnull OWLObjectProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDataPropertyComment(@Nonnull OWLDataProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeIndividualComments(@Nonnull OWLNamedIndividual ind) {
        this.writeComment(ind.getIRI().toString());
    }

    @Override
    protected void writeAnnotationPropertyComment(@Nonnull OWLAnnotationProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDatatypeComment(@Nonnull OWLDatatype datatype) {
        this.writeComment(datatype.getIRI().toString());
    }

    private void writeComment(@Nonnull String comment) {
        this.write("###  ");
        this.write(comment);
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void endObject() {
        this.writeNewLine();
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void writeBanner(String name) {
        this.writeNewLine();
        this.writeNewLine();
        this.writer.println("#################################################################");
        this.writer.println("#");
        this.writer.print("#    ");
        this.writer.println(name);
        this.writer.println("#");
        this.writer.println("#################################################################");
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    public void render(@Nonnull RDFResource node) {
        ++this.level;
        Collection<Object> triples = this.pending.contains(node) ? Collections.emptyList() : this.graph.getTriplesForSubject(node, true);
        this.pending.add(node);
        RDFResource lastSubject = null;
        RDFResourceIRI lastPredicate = null;
        boolean first = true;
        for (RDFTriple rDFTriple : triples) {
            RDFResource subj = rDFTriple.getSubject();
            RDFResourceIRI pred = rDFTriple.getPredicate();
            if (lastSubject != null && (subj.equals(lastSubject) || subj.isAnonymous())) {
                if (lastPredicate != null && pred.equals(lastPredicate)) {
                    this.write(" ,");
                    this.writeNewLine();
                    this.write(rDFTriple.getObject());
                } else {
                    this.write(" ;");
                    this.popTab();
                    if (!subj.isAnonymous()) {
                        this.writeNewLine();
                    }
                    this.writeNewLine();
                    this.write(rDFTriple.getPredicate());
                    this.write(" ");
                    this.pushTab();
                    this.write(rDFTriple.getObject());
                }
            } else {
                if (!first) {
                    this.popTab();
                    this.popTab();
                    this.writeNewLine();
                }
                if (!node.isAnonymous()) {
                    this.write(rDFTriple.getSubject());
                    this.write(" ");
                } else {
                    this.pushTab();
                    this.write("[");
                    this.write(" ");
                }
                this.pushTab();
                this.write(rDFTriple.getPredicate());
                this.write(" ");
                this.pushTab();
                this.write(rDFTriple.getObject());
            }
            lastSubject = subj;
            lastPredicate = pred;
            first = false;
        }
        if (node.isAnonymous()) {
            this.popTab();
            this.popTab();
            if (triples.isEmpty()) {
                this.write("[ ");
            } else {
                this.writeNewLine();
            }
            this.write("]");
            this.popTab();
        } else {
            this.popTab();
            this.popTab();
        }
        if (this.level == 1 && !triples.isEmpty()) {
            this.write(" .\n");
        }
        this.writer.flush();
        this.pending.remove(node);
        --this.level;
    }
}

