/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class SimpleRenderer
implements OWLObjectVisitor,
OWLObjectRenderer {
    private StringBuilder sb = new StringBuilder();
    private ShortFormProvider shortFormProvider;
    private IRIShortFormProvider iriShortFormProvider;

    public SimpleRenderer() {
        this.resetShortFormProvider();
    }

    public void reset() {
        this.sb = new StringBuilder();
    }

    public boolean isUsingDefaultShortFormProvider() {
        return this.shortFormProvider instanceof DefaultPrefixManager;
    }

    public final void resetShortFormProvider() {
        DefaultPrefixManager defaultPrefixManager = new DefaultPrefixManager();
        this.shortFormProvider = defaultPrefixManager;
        this.iriShortFormProvider = defaultPrefixManager;
    }

    public void setPrefixesFromOntologyFormat(@Nonnull OWLOntology ontology, @Nonnull OWLOntologyManager manager, boolean processImportedOntologies) {
        this.resetShortFormProvider();
        if (processImportedOntologies) {
            for (OWLOntology importedOntology : manager.getImportsClosure(ontology)) {
                if (importedOntology.equals(ontology)) continue;
                this.copyPrefixes(manager.getOntologyFormat(importedOntology));
            }
        }
        OWLDocumentFormat format = manager.getOntologyFormat(ontology);
        this.copyPrefixes(format);
    }

    private void copyPrefixes(OWLDocumentFormat ontologyFormat) {
        if (!(ontologyFormat instanceof PrefixDocumentFormat)) {
            return;
        }
        PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)ontologyFormat;
        for (Map.Entry<String, String> e : prefixFormat.getPrefixName2PrefixMap().entrySet()) {
            this.setPrefix(e.getKey(), e.getValue());
        }
    }

    public void setPrefix(@Nonnull String prefixName, @Nonnull String prefix) {
        if (!this.isUsingDefaultShortFormProvider()) {
            this.resetShortFormProvider();
        }
        ((DefaultPrefixManager)this.shortFormProvider).setPrefix(prefixName, prefix);
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public String getShortForm(@Nonnull IRI iri) {
        return this.iriShortFormProvider.getShortForm(iri);
    }

    @Override
    public String render(OWLObject object) {
        this.reset();
        object.accept(this);
        return this.sb.toString();
    }

    protected void render(Set<? extends OWLObject> objects) {
        Iterator<? extends OWLObject> it = SimpleRenderer.toSortedSet(objects).iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.sb.append(' ');
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.sb.append("Ontology(").append(ontology.getOntologyID()).append(" [Axioms: ").append(ontology.getAxiomCount()).append("] [Logical axioms: ").append(ontology.getLogicalAxiomCount()).append("])");
    }

    private void insertSpace() {
        this.sb.append(' ');
    }

    public void writeAnnotations(OWLAxiom axiom) {
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            anno.accept(this);
            this.insertSpace();
        }
    }

    private static <N extends OWLObject> Set<N> toSortedSet(Set<N> set) {
        return new TreeSet<N>(set);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.sb.append("SubClassOf(");
        this.writeAnnotations(axiom);
        axiom.getSubClass().accept(this);
        this.insertSpace();
        axiom.getSuperClass().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.sb.append("NegativeObjectPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.sb.append("AsymmetricObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.sb.append("ReflexiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.sb.append("DisjointClasses(");
        this.writeAnnotations(axiom);
        this.render(axiom.getClassExpressions());
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.sb.append("DataPropertyDomain(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getDomain().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.sb.append("ObjectPropertyDomain(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getDomain().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.sb.append("EquivalentObjectProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.sb.append("NegativeDataPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.sb.append("DifferentIndividuals(");
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.sb.append("DisjointDataProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.sb.append("DisjointObjectProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.sb.append("ObjectPropertyRange(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.sb.append("ObjectPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.sb.append("FunctionalObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.sb.append("SubObjectPropertyOf(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.sb.append("DisjointUnion(");
        this.writeAnnotations(axiom);
        axiom.getOWLClass().accept(this);
        this.insertSpace();
        this.render(axiom.getClassExpressions());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.sb.append("Declaration(");
        this.writeAnnotations(axiom);
        OWLEntity entity = axiom.getEntity();
        if (entity.isOWLClass()) {
            this.sb.append("Class(");
        } else if (entity.isOWLObjectProperty()) {
            this.sb.append("ObjectProperty(");
        } else if (entity.isOWLDataProperty()) {
            this.sb.append("DataProperty(");
        } else if (entity.isOWLNamedIndividual()) {
            this.sb.append("NamedIndividual(");
        } else if (entity.isOWLDatatype()) {
            this.sb.append("Datatype(");
        } else if (entity.isOWLAnnotationProperty()) {
            this.sb.append("AnnotationProperty(");
        }
        axiom.getEntity().accept(this);
        this.sb.append("))");
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.sb.append("AnnotationAssertion(");
        this.writeAnnotations(axiom);
        axiom.getProperty().accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        axiom.getValue().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.sb.append("SymmetricObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.sb.append("DataPropertyRange(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.sb.append("FunctionalDataProperty(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.sb.append("EquivalentDataProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.sb.append("ClassAssertion(");
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        this.insertSpace();
        axiom.getIndividual().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.sb.append("EquivalentClasses(");
        this.writeAnnotations(axiom);
        this.render(axiom.getClassExpressions());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.sb.append("DataPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.sb.append("TransitiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.sb.append("IrreflexiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.sb.append("SubDataPropertyOf(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.sb.append("InverseFunctionalObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.sb.append("SameIndividual(");
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.sb.append("SubObjectPropertyOf(");
        this.writeAnnotations(axiom);
        this.sb.append("ObjectPropertyChain(");
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            this.insertSpace();
            prop.accept(this);
        }
        this.sb.append(" )");
        this.insertSpace();
        axiom.getSuperProperty().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLClass ce) {
        this.sb.append(this.shortFormProvider.getShortForm(ce));
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.sb.append("ObjectIntersectionOf(");
        this.render(ce.getOperands());
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.sb.append("ObjectUnionOf(");
        this.render(ce.getOperands());
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.sb.append("ObjectComplementOf(");
        ce.getOperand().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.sb.append("ObjectSomeValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.sb.append("ObjectAllValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.sb.append("ObjectHasValue(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLIndividual)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.sb.append("ObjectMinCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.sb.append("ObjectExactCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.sb.append("ObjectMaxCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.sb.append("ObjectHasSelf(");
        ce.getProperty().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.sb.append("ObjectOneOf(");
        this.render(ce.getIndividuals());
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.sb.append("DataSomeValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.sb.append("DataAllValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.sb.append("DataHasValue(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLLiteral)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.sb.append("DataMinCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.sb.append("DataExactCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.sb.append("DataMaxCardinality(");
        this.sb.append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDatatype node) {
        this.sb.append(this.shortFormProvider.getShortForm(node));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.sb.append("DataComplementOf(");
        node.getDataRange().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.sb.append("DataOneOf(");
        this.render(node.getValues());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.sb.append("DataRangeRestriction(");
        node.getDatatype().accept(this);
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            this.insertSpace();
            restriction.accept(this);
        }
        this.sb.append(')');
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.sb.append("facetRestriction(");
        this.sb.append(node.getFacet());
        this.insertSpace();
        node.getFacetValue().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLLiteral node) {
        String literal = EscapeUtils.escapeString(node.getLiteral());
        if (node.isRDFPlainLiteral()) {
            this.sb.append('\"').append(literal).append('\"');
            if (node.hasLang()) {
                this.sb.append('@').append(node.getLang());
            }
        } else {
            this.sb.append('\"').append(literal).append("\"^^");
            node.getDatatype().accept(this);
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.sb.append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.sb.append("InverseOf(");
        property.getInverse().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.sb.append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.sb.append(this.shortFormProvider.getShortForm(individual));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.sb.append("InverseObjectProperties(");
        this.writeAnnotations(axiom);
        axiom.getFirstProperty().accept(this);
        this.sb.append(' ');
        axiom.getSecondProperty().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.sb.append("HasKey(");
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        this.sb.append(" (");
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axiom.getObjectPropertyExpressions()) {
            oWLObjectPropertyExpression.accept(this);
            this.sb.append(' ');
        }
        this.sb.append(") (");
        for (OWLDataPropertyExpression oWLDataPropertyExpression : axiom.getDataPropertyExpressions()) {
            oWLDataPropertyExpression.accept(this);
            this.sb.append(' ');
        }
        this.sb.append(')');
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.sb.append("DataIntersectionOf(");
        for (OWLDataRange rng : node.getOperands()) {
            rng.accept(this);
            this.sb.append(' ');
        }
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.sb.append("DataUnionOf(");
        for (OWLDataRange rng : node.getOperands()) {
            rng.accept(this);
            this.sb.append(' ');
        }
        this.sb.append(')');
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.sb.append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.sb.append("AnnotationPropertyDomain(");
        axiom.getProperty().accept(this);
        this.sb.append(' ');
        axiom.getDomain().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.sb.append("AnnotationPropertyRange(");
        axiom.getProperty().accept(this);
        this.sb.append(' ');
        axiom.getRange().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.sb.append("SubAnnotationPropertyOf(");
        this.writeAnnotations(axiom);
        axiom.getSubProperty().accept(this);
        this.sb.append(' ');
        axiom.getSuperProperty().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.sb.append(individual.getID());
    }

    @Override
    public void visit(IRI iri) {
        this.sb.append('<');
        this.sb.append(iri);
        this.sb.append('>');
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.sb.append("Annotation(");
        Set<OWLAnnotation> annos = node.getAnnotations();
        for (OWLAnnotation anno : annos) {
            anno.accept(this);
            this.sb.append(' ');
        }
        node.getProperty().accept(this);
        this.sb.append(' ');
        node.getValue().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLRule rule) {
        this.sb.append("DLSafeRule(");
        this.writeAnnotations(rule);
        this.sb.append(" Body(");
        this.render(rule.getBody());
        this.sb.append(')');
        this.sb.append(" Head(");
        this.render(rule.getHead());
        this.sb.append(')');
        this.sb.append(" )");
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.sb.append("ClassAtom(");
        node.getPredicate().accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.sb.append("DataRangeAtom(");
        node.getPredicate().accept(this);
        this.sb.append(' ');
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.sb.append("DifferentFromAtom(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.sb.append("SameAsAtom(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.sb.append("ObjectPropertyAtom(");
        node.getPredicate().accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.sb.append("DataPropertyAtom(");
        node.getPredicate().accept(this);
        this.sb.append(' ');
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.sb.append(' ');
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.sb.append("BuiltInAtom(");
        this.sb.append(this.getShortForm(node.getPredicate()));
        this.sb.append(' ');
        for (SWRLArgument sWRLArgument : node.getArguments()) {
            sWRLArgument.accept(this);
            this.sb.append(' ');
        }
        this.sb.append(')');
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.sb.append("DatatypeDefinition(");
        this.writeAnnotations(axiom);
        axiom.getDatatype().accept(this);
        this.sb.append(' ');
        axiom.getDataRange().accept(this);
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLVariable node) {
        this.sb.append("Variable(");
        this.sb.append(this.getShortForm(node.getIRI()));
        this.sb.append(')');
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    public String toString() {
        return this.sb.toString();
    }
}

