/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.owlapi.AbstractInMemOWLOntologyFactory;

public class EmptyInMemOWLOntologyFactory
extends AbstractInMemOWLOntologyFactory {
    private static final long serialVersionUID = 40000L;

    @Inject
    public EmptyInMemOWLOntologyFactory(@Nonnull OWLOntologyBuilder builder) {
        super(builder);
    }

    @Override
    @Nonnull
    public OWLOntology loadOWLOntology(OWLOntologyManager manager, OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration configuration) {
        throw new OWLRuntimeException(new UnsupportedOperationException("Cannot load OWL ontologies in an empty factory."));
    }

    @Override
    public OWLOntology createOWLOntology(OWLOntologyManager manager, OWLOntologyID ontologyID, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) {
        OWLOntology ont = super.createOWLOntology(manager, ontologyID, documentIRI, handler);
        handler.setOntologyFormat(ont, new RDFXMLDocumentFormat());
        return ont;
    }

    @Override
    public boolean canLoad(OWLOntologyDocumentSource documentSource) {
        return false;
    }
}

