/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.jboss.logging.Logger;

public class PagedReferenceImpl
extends LinkedListImpl.Node<PagedReferenceImpl>
implements PagedReference {
    private static final Logger logger = Logger.getLogger(PagedReferenceImpl.class);
    private final PagePosition position;
    private WeakReference<PagedMessage> message;
    private Long deliveryTime = null;
    private int persistedCount;
    private int messageEstimate = -1;
    private Long consumerId;
    private final AtomicInteger deliveryCount = new AtomicInteger(0);
    private final PageSubscription subscription;
    private boolean alreadyAcked;
    private Object protocolData;
    private Boolean largeMessage;
    private long transactionID = -1L;
    private long messageID = -1L;
    private long messageSize = -1L;

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public Message getMessage() {
        return this.getPagedMessage().getMessage();
    }

    @Override
    public synchronized PagedMessage getPagedMessage() {
        PagedMessage returnMessage;
        PagedMessage pagedMessage = returnMessage = this.message != null ? (PagedMessage)this.message.get() : null;
        if (returnMessage == null) {
            returnMessage = this.subscription.queryMessage(this.position);
            this.message = new WeakReference<PagedMessage>(returnMessage);
        }
        return returnMessage;
    }

    @Override
    public PagePosition getPosition() {
        return this.position;
    }

    public PagedReferenceImpl(PagePosition position, PagedMessage message, PageSubscription subscription) {
        this.position = position;
        this.message = new WeakReference<PagedMessage>(message);
        this.subscription = subscription;
        if (message != null) {
            this.largeMessage = message.getMessage().isLargeMessage();
            this.transactionID = message.getTransactionID();
            this.messageID = message.getMessage().getMessageID();
            this.getPersistentSize();
        } else {
            this.largeMessage = null;
            this.transactionID = -1L;
            this.messageID = -1L;
            this.messageSize = -1L;
        }
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public void setPersistedCount(int count) {
        this.persistedCount = count;
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public int getMessageMemoryEstimate() {
        if (this.messageEstimate <= 0) {
            try {
                this.messageEstimate = this.getMessage().getMemoryEstimate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculateMessageMemoryEstimate(e);
            }
        }
        return this.messageEstimate;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new PagedReferenceImpl(this.position, this.getPagedMessage(), this.subscription);
    }

    @Override
    public long getScheduledDeliveryTime() {
        if (this.deliveryTime == null) {
            try {
                Message msg = this.getMessage();
                return msg.getScheduledDeliveryTime();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculateScheduledDeliveryTime(e);
                return 0L;
            }
        }
        return this.deliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.deliveryTime = scheduledDeliveryTime;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount.get();
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount.set(deliveryCount);
    }

    @Override
    public void incrementDeliveryCount() {
        this.deliveryCount.incrementAndGet();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("++deliveryCount = " + this.deliveryCount + " for " + this), (Throwable)new Exception("trace"));
        }
    }

    @Override
    public void decrementDeliveryCount() {
        this.deliveryCount.decrementAndGet();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("--deliveryCount = " + this.deliveryCount + " for " + this), (Throwable)new Exception("trace"));
        }
    }

    @Override
    public Queue getQueue() {
        return this.subscription.getQueue();
    }

    @Override
    public void handled() {
        this.getQueue().referenceHandled(this);
    }

    @Override
    public void setAlreadyAcked() {
        this.alreadyAcked = true;
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.alreadyAcked;
    }

    @Override
    public void acknowledge() throws Exception {
        this.subscription.ack(this);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.acknowledge(tx, AckReason.NORMAL);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason) throws Exception {
        if (tx == null) {
            this.getQueue().acknowledge(this, reason);
        } else {
            this.getQueue().acknowledge(tx, this, reason);
        }
    }

    public String toString() {
        String msgToString;
        try {
            msgToString = this.getPagedMessage().toString();
        }
        catch (Throwable e) {
            msgToString = "error:" + e.getMessage();
        }
        return "PagedReferenceImpl [position=" + this.position + ", message=" + msgToString + ", deliveryTime=" + this.deliveryTime + ", persistedCount=" + this.persistedCount + ", deliveryCount=" + this.deliveryCount + ", subscription=" + this.subscription + "]";
    }

    @Override
    public void setConsumerId(Long consumerID) {
        this.consumerId = consumerID;
    }

    @Override
    public Long getConsumerId() {
        return this.consumerId;
    }

    @Override
    public boolean isLargeMessage() {
        if (this.largeMessage == null && this.message != null) {
            this.largeMessage = this.getMessage().isLargeMessage();
        }
        return this.largeMessage;
    }

    @Override
    public long getTransactionID() {
        if (this.transactionID < 0L) {
            this.transactionID = this.getPagedMessage().getTransactionID();
        }
        return this.transactionID;
    }

    @Override
    public long getMessageID() {
        if (this.messageID < 0L) {
            this.messageID = this.getPagedMessage().getMessage().getMessageID();
        }
        return this.messageID;
    }

    @Override
    public long getPersistentSize() {
        if (this.messageSize == -1L) {
            try {
                this.messageSize = this.getPagedMessage().getPersistentSize();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
            }
        }
        return this.messageSize;
    }
}

