/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.nullpm;

import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

class NullStorageLargeServerMessage
extends CoreMessage
implements LargeServerMessage {
    NullStorageLargeServerMessage() {
    }

    NullStorageLargeServerMessage(NullStorageLargeServerMessage other) {
        super((CoreMessage)other);
    }

    @Override
    public void releaseResources() {
    }

    @Override
    public synchronized void addBytes(byte[] bytes) {
        if (this.buffer == null) {
            this.buffer = ActiveMQBuffers.dynamicBuffer((int)bytes.length).byteBuf();
        }
        this.buffer.writeBytes(bytes);
    }

    @Override
    public void deleteFile() throws Exception {
    }

    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public void decrementDelayDeletionCount() {
    }

    @Override
    public void incrementDelayDeletionCount() {
    }

    public boolean isServerMessage() {
        return true;
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    public String toString() {
        return "NullStorageLargeServerMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]";
    }

    public Message copy() {
        return new NullStorageLargeServerMessage(this);
    }

    @Override
    public void setPaged() {
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
    }

    @Override
    public long getPendingRecordID() {
        return -1L;
    }

    @Override
    public SequentialFile getFile() {
        return null;
    }
}

