/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.jboss.logging.Logger;

final class JdbcLeaseLock
implements LeaseLock {
    private static final Logger LOGGER = Logger.getLogger(JdbcLeaseLock.class);
    private static final int MAX_HOLDER_ID_LENGTH = 128;
    private final Connection connection;
    private final long maxAllowableMillisDiffFromDBTime;
    private long millisDiffFromCurrentTime;
    private final String holderId;
    private final PreparedStatement tryAcquireLock;
    private final PreparedStatement tryReleaseLock;
    private final PreparedStatement renewLock;
    private final PreparedStatement isLocked;
    private final PreparedStatement currentDateTime;
    private final long expirationMillis;
    private boolean maybeAcquired;

    JdbcLeaseLock(String holderId, Connection connection, PreparedStatement tryAcquireLock, PreparedStatement tryReleaseLock, PreparedStatement renewLock, PreparedStatement isLocked, PreparedStatement currentDateTime, long expirationMIllis, long maxAllowableMillisDiffFromDBTime) {
        if (holderId.length() > 128) {
            throw new IllegalArgumentException("holderId length must be <=128");
        }
        this.holderId = holderId;
        this.maxAllowableMillisDiffFromDBTime = maxAllowableMillisDiffFromDBTime;
        this.millisDiffFromCurrentTime = Long.MAX_VALUE;
        this.tryAcquireLock = tryAcquireLock;
        this.tryReleaseLock = tryReleaseLock;
        this.renewLock = renewLock;
        this.isLocked = isLocked;
        this.currentDateTime = currentDateTime;
        this.expirationMillis = expirationMIllis;
        this.maybeAcquired = false;
        this.connection = connection;
    }

    public String holderId() {
        return this.holderId;
    }

    @Override
    public long expirationMillis() {
        return this.expirationMillis;
    }

    private long timeDifference() throws SQLException {
        if (Long.MAX_VALUE == this.millisDiffFromCurrentTime) {
            this.millisDiffFromCurrentTime = this.maxAllowableMillisDiffFromDBTime > 0L ? this.determineTimeDifference() : 0L;
        }
        return this.millisDiffFromCurrentTime;
    }

    private long determineTimeDifference() throws SQLException {
        try (ResultSet resultSet = this.currentDateTime.executeQuery();){
            long result = 0L;
            if (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp(1);
                long diff = System.currentTimeMillis() - timestamp.getTime();
                if (Math.abs(diff) > this.maxAllowableMillisDiffFromDBTime) {
                    result = -diff;
                }
                LOGGER.info((Object)(this.holderId() + " diff adjust from db: " + result + ", db time: " + timestamp));
            }
            long l = result;
            return l;
        }
    }

    @Override
    public boolean renew() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                boolean result;
                this.connection.setAutoCommit(false);
                try {
                    long timeDifference = this.timeDifference();
                    PreparedStatement preparedStatement = this.renewLock;
                    long now = System.currentTimeMillis() + timeDifference;
                    Timestamp timestamp = new Timestamp(now + this.expirationMillis);
                    preparedStatement.setTimestamp(1, timestamp);
                    preparedStatement.setString(2, this.holderId);
                    result = preparedStatement.executeUpdate() == 1;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw new IllegalStateException(ie);
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
                return result;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public boolean tryAcquire() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                boolean acquired;
                this.connection.setAutoCommit(false);
                try {
                    long timeDifference = this.timeDifference();
                    PreparedStatement preparedStatement = this.tryAcquireLock;
                    long now = System.currentTimeMillis() + timeDifference;
                    preparedStatement.setString(1, this.holderId);
                    Timestamp timestamp = new Timestamp(now + this.expirationMillis);
                    preparedStatement.setTimestamp(2, timestamp);
                    acquired = preparedStatement.executeUpdate() == 1;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw new IllegalStateException(ie);
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
                if (acquired) {
                    this.maybeAcquired = true;
                }
                return acquired;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public boolean isHeld() {
        return this.checkValidHolderId(Objects::nonNull);
    }

    @Override
    public boolean isHeldByCaller() {
        return this.checkValidHolderId(this.holderId::equals);
    }

    private boolean checkValidHolderId(Predicate<? super String> holderIdFilter) {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                boolean result;
                this.connection.setAutoCommit(false);
                try {
                    long timeDifference = this.timeDifference();
                    PreparedStatement preparedStatement = this.isLocked;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (!resultSet.next()) {
                            result = false;
                        } else {
                            String currentHolderId = resultSet.getString(1);
                            result = holderIdFilter.test(currentHolderId);
                            Timestamp timestamp = resultSet.getTimestamp(2);
                            if (timestamp != null) {
                                long lockExpirationTime = timestamp.getTime();
                                long now = System.currentTimeMillis() + timeDifference;
                                long expiredBy = now - lockExpirationTime;
                                if (expiredBy > 0L) {
                                    result = false;
                                    LOGGER.warn((Object)("found zombie lock with holderId: " + currentHolderId + " expired by: " + expiredBy + " ms"));
                                }
                            }
                        }
                    }
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw new IllegalStateException(ie);
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
                return result;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                try {
                    PreparedStatement preparedStatement = this.tryReleaseLock;
                    preparedStatement.setString(1, this.holderId);
                    if (preparedStatement.executeUpdate() != 1) {
                        LOGGER.warn((Object)(this.holderId + " has failed to release a lock"));
                    } else {
                        LOGGER.info((Object)(this.holderId + " has released a lock"));
                    }
                    this.maybeAcquired = false;
                }
                catch (SQLException ie) {
                    this.connection.rollback();
                    this.connection.setAutoCommit(true);
                    throw new IllegalStateException(ie);
                }
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.tryReleaseLock.isClosed()) {
                try {
                    if (this.maybeAcquired) {
                        this.release();
                    }
                }
                finally {
                    this.tryReleaseLock.close();
                    this.tryAcquireLock.close();
                    this.renewLock.close();
                    this.isLocked.close();
                    this.currentDateTime.close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

