/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

public class MetadataMap<K, V>
implements MultivaluedMap<K, V> {
    private boolean caseInsensitive;
    private boolean readOnly;
    private Map<K, List<V>> m;

    public MetadataMap() {
        this.m = new LinkedHashMap<K, List<V>>();
    }

    public MetadataMap(int size) {
        this.m = new LinkedHashMap<K, List<V>>(size);
    }

    public MetadataMap(Map<K, List<V>> store) {
        this(store, true);
    }

    public MetadataMap(Map<K, List<V>> store, boolean copy) {
        this(store, copy, false, false);
    }

    public MetadataMap(boolean readOnly, boolean caseInsensitive) {
        this(null, readOnly, caseInsensitive);
    }

    public MetadataMap(Map<K, List<V>> store, boolean readOnly, boolean caseInsensitive) {
        this(store, true, readOnly, caseInsensitive);
    }

    public MetadataMap(Map<K, List<V>> store, boolean copyStore, boolean readOnly, boolean caseInsensitive) {
        if (copyStore) {
            this.m = new LinkedHashMap<K, List<V>>();
            if (store != null) {
                for (Map.Entry<K, List<List<V>>> entry : store.entrySet()) {
                    ArrayList values = new ArrayList(entry.getValue());
                    this.m.put(entry.getKey(), values);
                }
            }
        } else {
            this.m = store;
        }
        if (readOnly) {
            this.m = Collections.unmodifiableMap(this.m);
        }
        this.caseInsensitive = caseInsensitive;
        this.readOnly = readOnly;
    }

    public void add(K key, V value) {
        this.addValue(key, value, true);
    }

    private void addValue(K key, V value, boolean last) {
        List<V> data = this.getList(key);
        try {
            if (last) {
                data.add(value);
            } else {
                data.add(0, value);
            }
        }
        catch (UnsupportedOperationException ex) {
            if (!this.readOnly) {
                ArrayList<V> newList = new ArrayList<V>(data);
                this.put(key, newList);
                this.addValue(key, value, last);
            }
            throw ex;
        }
    }

    private List<V> getList(K key) {
        ArrayList data = this.get(key);
        if (data == null) {
            data = new ArrayList();
            this.m.put(key, data);
        }
        return this.readOnly ? Collections.unmodifiableList(data) : data;
    }

    public V getFirst(K key) {
        Object data = this.get(key);
        return data == null ? null : (V)data.get(0);
    }

    public void putSingle(K key, V value) {
        ArrayList<V> data = new ArrayList<V>();
        data.add(value);
        this.put(key, data);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        if (!this.caseInsensitive) {
            return this.m.containsKey(key);
        }
        return this.getMatchingKey(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m.entrySet();
    }

    public List<V> get(Object key) {
        if (!this.caseInsensitive) {
            return this.m.get(key);
        }
        K realKey = this.getMatchingKey(key);
        return realKey == null ? null : this.m.get(realKey);
    }

    private K getMatchingKey(Object key) {
        for (K entry : this.m.keySet()) {
            if (!entry.toString().equalsIgnoreCase(key.toString())) continue;
            return entry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<K> keySet() {
        if (!this.caseInsensitive) {
            return this.m.keySet();
        }
        TreeSet set = new TreeSet(new KeyComparator());
        set.addAll(this.m.keySet());
        return set;
    }

    public List<V> put(K key, List<V> value) {
        K realKey = !this.caseInsensitive ? key : this.getMatchingKey(key);
        return this.m.put(realKey == null ? key : realKey, value);
    }

    public void putAll(Map<? extends K, ? extends List<V>> map) {
        if (!this.caseInsensitive) {
            this.m.putAll(map);
        } else {
            for (Map.Entry<K, List<V>> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public List<V> remove(Object key) {
        if (this.caseInsensitive) {
            K realKey = this.getMatchingKey(key);
            return this.m.remove(realKey == null ? key : realKey);
        }
        return this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public Collection<List<V>> values() {
        return this.m.values();
    }

    public int hashCode() {
        return ((Object)this.m).hashCode();
    }

    public boolean equals(Object o) {
        return ((Object)this.m).equals(o);
    }

    public String toString() {
        return this.m.toString();
    }

    public void addAll(K key, V ... newValues) {
        this.addAllValues(key, Arrays.asList(newValues));
    }

    public void addAll(K key, List<V> newValues) {
        this.addAllValues(key, newValues);
    }

    private void addAllValues(K key, List<V> newValues) {
        if (newValues == null) {
            throw new NullPointerException("List is empty");
        }
        if (newValues.isEmpty()) {
            return;
        }
        this.getList(key).addAll(newValues);
    }

    public void addFirst(K key, V value) {
        this.addValue(key, value, false);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<K, V> map) {
        Set mapKeys = map.keySet();
        if (mapKeys.size() != this.m.keySet().size()) {
            return false;
        }
        for (Object key : mapKeys) {
            Object localValues = this.get(key);
            List mapValues = (List)map.get(key);
            if (localValues != null && localValues.size() == mapValues.size() && localValues.containsAll(mapValues)) continue;
            return false;
        }
        return true;
    }

    private static class KeyComparator<K>
    implements Comparator<K> {
        private KeyComparator() {
        }

        @Override
        public int compare(K k1, K k2) {
            String s1 = k1.toString();
            String s2 = k2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

