/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

class ServletExporter
implements ManagedService {
    protected static final Logger LOG = LogUtils.getL7dLogger(ServletExporter.class);
    private String alias;
    private Servlet servlet;
    private ServiceRegistration serviceRegistration;
    private HttpService httpService;

    public ServletExporter(Servlet servlet, HttpService httpService) {
        this.servlet = servlet;
        this.httpService = httpService;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (this.alias != null) {
            this.httpService.unregister(this.alias);
            this.alias = null;
        }
        if (properties == null) {
            properties = new Properties();
        }
        Properties sprops = new Properties();
        sprops.put("init-prefix", this.getProp(properties, "org.apache.cxf.servlet.init-prefix", ""));
        sprops.put("servlet-name", this.getProp(properties, "org.apache.cxf.servlet.name", "cxf-osgi-transport-servlet"));
        sprops.put("hide-service-list-page", this.getProp(properties, "org.apache.cxf.servlet.hide-service-list-page", "false"));
        sprops.put("disable-address-updates", this.getProp(properties, "org.apache.cxf.servlet.disable-address-updates", "true"));
        sprops.put("base-address", this.getProp(properties, "org.apache.cxf.servlet.base-address", ""));
        sprops.put("service-list-path", this.getProp(properties, "org.apache.cxf.servlet.service-list-path", ""));
        sprops.put("static-resources-list", this.getProp(properties, "org.apache.cxf.servlet.static-resources-list", ""));
        sprops.put("redirects-list", this.getProp(properties, "org.apache.cxf.servlet.redirects-list", ""));
        sprops.put("redirect-servlet-name", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-name", ""));
        sprops.put("redirect-servlet-path", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-path", ""));
        sprops.put("service-list-all-contexts", this.getProp(properties, "org.apache.cxf.servlet.service-list-all-contexts", ""));
        sprops.put("service-list-page-authenticate", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate", "false"));
        sprops.put("service-list-page-authenticate-realm", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate-realm", "karaf"));
        sprops.put("use-x-forwarded-headers", this.getProp(properties, "org.apache.cxf.servlet.use-x-forwarded-headers", "false"));
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        this.alias = (String)this.getProp(properties, "org.apache.cxf.servlet.context", "/cxf");
        HttpContext context = this.httpService.createDefaultHttpContext();
        try {
            this.httpService.registerServlet(this.alias, this.servlet, sprops, context);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error registering CXF OSGi servlet " + e.getMessage(), e);
        }
    }

    private Object getProp(Dictionary properties, String key, Object defaultValue) {
        Object value = properties.get(key);
        return value == null ? defaultValue : value;
    }
}

