/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import aQute.bnd.version.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.felix.bundleplugin.baseline.AbstractBaselinePlugin;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="baseline-report", threadSafe=true, defaultPhase=LifecyclePhase.SITE)
public final class BaselineReport
extends AbstractBaselinePlugin
implements MavenReport {
    @Parameter(defaultValue="${project.reporting.outputDirectory}")
    private File outputDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object init(Object context) {
        this.failOnError = false;
        this.failOnWarning = false;
        File baselineImagesDirectory = new File(this.outputDirectory, "images/baseline");
        baselineImagesDirectory.mkdirs();
        for (String resourceName : new String[]{"access.gif", "annotated.gif", "annotation.gif", "bundle.gif", "class.gif", "constant.gif", "enum.gif", "error.gif", "extends.gif", "field.gif", "implements.gif", "info.gif", "interface.gif", "method.gif", "package.gif", "resource.gif", "return.gif", "version.gif", "warning.gif"}) {
            InputStream source = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
            OutputStream target = null;
            File targetFile = new File(baselineImagesDirectory, resourceName);
            try {
                target = this.buildContext.newFileOutputStream(targetFile);
                IOUtil.copy((InputStream)source, (OutputStream)target);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Impossible to copy " + resourceName + " image, maybe the site won't be properly rendered."));
            }
            finally {
                IOUtil.close((InputStream)source);
                IOUtil.close((OutputStream)target);
            }
        }
        return context;
    }

    @Override
    protected void close(Object context) {
    }

    @Override
    protected void startBaseline(Object context, String generationDate, String bundleName, String currentVersion, String previousVersion) {
        Context ctx = (Context)context;
        Sink sink = ctx.sink;
        sink.head();
        sink.title();
        String title = this.getBundle(ctx.locale).getString("report.baseline.title");
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.getBundle(ctx.locale).getString("report.baseline.bndlink") + " ");
        sink.link("http://www.aqute.biz/Bnd/Bnd");
        sink.text("Bnd");
        sink.link_();
        sink.text(".");
        sink.paragraph_();
        sink.paragraph();
        sink.text(this.getBundle(ctx.locale).getString("report.baseline.bundle") + " ");
        sink.figure();
        sink.figureGraphics("images/baseline/bundle.gif");
        sink.figure_();
        sink.text(" ");
        sink.bold();
        sink.text(bundleName);
        sink.bold_();
        sink.listItem_();
        sink.paragraph();
        sink.text(this.getBundle(ctx.locale).getString("report.baseline.version.current") + " ");
        sink.bold();
        sink.text(currentVersion);
        sink.bold_();
        sink.paragraph_();
        sink.paragraph();
        sink.text(this.getBundle(ctx.locale).getString("report.baseline.version.comparison") + " ");
        sink.bold();
        sink.text(this.comparisonVersion);
        sink.bold_();
        sink.paragraph_();
        sink.paragraph();
        sink.text(this.getBundle(ctx.locale).getString("report.baseline.generationdate") + " ");
        sink.bold();
        sink.text(generationDate);
        sink.bold_();
        sink.paragraph_();
        sink.section1_();
    }

    @Override
    protected void startPackage(Object context, boolean mismatch, String packageName, String shortDelta, String delta, Version newerVersion, Version olderVersion, Version suggestedVersion, DiffMessage diffMessage, Map<String, String> attributes) {
        Context ctx = (Context)context;
        Sink sink = ctx.sink;
        sink.list();
        sink.listItem();
        sink.figure();
        sink.figureGraphics("./images/baseline/package.gif");
        sink.figure_();
        sink.text(" ");
        sink.monospaced();
        sink.text(packageName);
        sink.monospaced_();
        if (diffMessage != null) {
            sink.text(" ");
            sink.figure();
            sink.figureGraphics("./images/baseline/" + diffMessage.getType().name() + ".gif");
            sink.figure_();
            sink.text(" ");
            sink.italic();
            sink.text(diffMessage.getMessage());
            sink.italic_();
            sink.text(" (newer version: ");
            sink.monospaced();
            sink.text(newerVersion.toString());
            sink.monospaced_();
            sink.text(", older version: ");
            sink.monospaced();
            sink.text(olderVersion.toString());
            if (suggestedVersion != null) {
                sink.monospaced_();
                sink.text(", suggested version: ");
                sink.monospaced();
                sink.text(suggestedVersion.toString());
            }
            sink.monospaced_();
            sink.text(")");
        }
    }

    @Override
    protected void startDiff(Object context, int depth, String type, String name, String delta, String shortDelta) {
        Context ctx = (Context)context;
        Sink sink = ctx.sink;
        if (ctx.currentDepth < depth) {
            sink.list();
        }
        ctx.currentDepth = depth;
        sink.listItem();
        sink.figure();
        sink.figureGraphics("images/baseline/" + type + ".gif");
        sink.figure_();
        sink.text(" ");
        sink.monospaced();
        sink.text(name);
        sink.monospaced_();
        sink.text(" ");
        sink.italic();
        sink.text(delta);
        sink.italic_();
    }

    @Override
    protected void endDiff(Object context, int depth) {
        Context ctx = (Context)context;
        Sink sink = ctx.sink;
        sink.listItem_();
        if (ctx.currentDepth > depth) {
            sink.list_();
        }
        ctx.currentDepth = depth;
    }

    @Override
    protected void endPackage(Object context) {
        Context ctx = (Context)context;
        Sink sink = ctx.sink;
        if (ctx.currentDepth > 0) {
            sink.list_();
            ctx.currentDepth = 0;
        }
        sink.listItem_();
        sink.list_();
    }

    @Override
    protected void endBaseline(Object context) {
        Context ctx = (Context)context;
        ctx.sink.body_();
        ctx.sink.flush();
        ctx.sink.close();
    }

    public boolean canGenerateReport() {
        return !this.skip && this.outputDirectory != null;
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        Context ctx = new Context();
        ctx.sink = sink;
        ctx.locale = locale;
        try {
            this.execute(ctx);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"An error occurred while producing the report page, see nested exceptions", (Throwable)e);
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.baseline.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.baseline.name");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("baseline-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getOutputName() {
        return "baseline-report";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private static final class Context {
        public Sink sink;
        public Locale locale;
        public int currentDepth = 0;

        private Context() {
        }
    }
}

