/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.PrintWriter;
import org.apache.kafka.streams.kstream.ForeachAction;

public class PrintForeachAction<K, V>
implements ForeachAction<K, V> {
    private final String streamName;
    private final PrintWriter printWriter;

    public PrintForeachAction(PrintWriter printWriter, String streamName) {
        this.printWriter = printWriter;
        this.streamName = streamName;
    }

    @Override
    public void apply(K key, V value) {
        String data = String.format("[%s]: %s, %s", this.streamName, key, value);
        if (this.printWriter == null) {
            System.out.println(data);
        } else {
            this.printWriter.println(data);
        }
    }

    public void close() {
        if (this.printWriter == null) {
            System.out.flush();
        } else {
            this.printWriter.close();
        }
    }
}

