/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.RecordDeserializer;
import org.apache.kafka.streams.processor.internals.SourceNode;

class SourceNodeRecordDeserializer
implements RecordDeserializer {
    private final SourceNode sourceNode;

    SourceNodeRecordDeserializer(SourceNode sourceNode) {
        this.sourceNode = sourceNode;
    }

    @Override
    public ConsumerRecord<Object, Object> deserialize(ConsumerRecord<byte[], byte[]> rawRecord) {
        Object value;
        Object key;
        try {
            key = this.sourceNode.deserializeKey(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.key());
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to deserialize key for record. topic=%s, partition=%d, offset=%d", rawRecord.topic(), rawRecord.partition(), rawRecord.offset()), e);
        }
        try {
            value = this.sourceNode.deserializeValue(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.value());
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to deserialize value for record. topic=%s, partition=%d, offset=%d", rawRecord.topic(), rawRecord.partition(), rawRecord.offset()), e);
        }
        return new ConsumerRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), rawRecord.timestamp(), TimestampType.CREATE_TIME, rawRecord.checksum(), rawRecord.serializedKeySize(), rawRecord.serializedValueSize(), key, value);
    }
}

