/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public final class StateSerdes<K, V> {
    private final String topic;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public static <K, V> StateSerdes<K, V> withBuiltinTypes(String topic, Class<K> keyClass, Class<V> valueClass) {
        return new StateSerdes<K, V>(topic, Serdes.serdeFrom(keyClass), Serdes.serdeFrom(valueClass));
    }

    public StateSerdes(String topic, Serde<K> keySerde, Serde<V> valueSerde) {
        if (topic == null) {
            throw new IllegalArgumentException("topic cannot be null");
        }
        if (keySerde == null) {
            throw new IllegalArgumentException("key serde cannot be null");
        }
        if (valueSerde == null) {
            throw new IllegalArgumentException("value serde cannot be null");
        }
        this.topic = topic;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Deserializer<K> keyDeserializer() {
        return this.keySerde.deserializer();
    }

    public Serializer<K> keySerializer() {
        return this.keySerde.serializer();
    }

    public Deserializer<V> valueDeserializer() {
        return this.valueSerde.deserializer();
    }

    public Serializer<V> valueSerializer() {
        return this.valueSerde.serializer();
    }

    public String topic() {
        return this.topic;
    }

    public K keyFrom(byte[] rawKey) {
        return (K)this.keySerde.deserializer().deserialize(this.topic, rawKey);
    }

    public V valueFrom(byte[] rawValue) {
        return (V)this.valueSerde.deserializer().deserialize(this.topic, rawValue);
    }

    public byte[] rawKey(K key) {
        return this.keySerde.serializer().serialize(this.topic, key);
    }

    public byte[] rawValue(V value) {
        return this.valueSerde.serializer().serialize(this.topic, value);
    }
}

