/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.InnerMeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements KeyValueStore<K, V> {
    protected final Time time;
    private final InnerMeteredKeyValueStore<K, K, V, V> innerMetered;

    public MeteredKeyValueStore(KeyValueStore<K, V> inner, String metricScope, Time time) {
        super(inner);
        this.time = time != null ? time : Time.SYSTEM;
        this.innerMetered = new InnerMeteredKeyValueStore(inner, metricScope, new InnerMeteredKeyValueStore.TypeConverter<K, K, V, V>(){

            @Override
            public K innerKey(K key) {
                return key;
            }

            @Override
            public V innerValue(V value) {
                return value;
            }

            @Override
            public List<KeyValue<K, V>> innerEntries(List<KeyValue<K, V>> from) {
                return from;
            }

            @Override
            public V outerValue(V value) {
                return value;
            }

            @Override
            public KeyValue<K, V> outerKeyValue(KeyValue<K, V> from) {
                return from;
            }

            @Override
            public K outerKey(K key) {
                return key;
            }
        }, time);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.innerMetered.init(context, root);
    }

    @Override
    public long approximateNumEntries() {
        return this.innerMetered.approximateNumEntries();
    }

    @Override
    public V get(K key) {
        return this.innerMetered.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.innerMetered.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.innerMetered.putIfAbsent(key, value);
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        this.innerMetered.putAll(entries);
    }

    @Override
    public V delete(K key) {
        return this.innerMetered.delete(key);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return this.innerMetered.range(from, to);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return this.innerMetered.all();
    }

    @Override
    public void flush() {
        this.innerMetered.flush();
    }
}

