/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.server.KafkaApis;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u000f\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A\u0019\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%\t\u0012B\u0001\n\u000b\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0005\u0003\u0015)H/\u001b7t\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nm\t!!\u001b3\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u0007%sG\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001c\u0003!\u0011'o\\6fe&#\u0007\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002%\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM]\u000b\u0002MA\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u0005G>\u0014XM\u0003\u0002,Y\u00059Q.\u001a;sS\u000e\u001c(BA\u0017/\u0003\u0019I\u0018-\\7fe*\tq&A\u0002d_6L!!\r\u0015\u0003\u000b5+G/\u001a:\t\u0011M\u0002!\u0011!Q\u0001\n\u0019\n1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0014i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm]\u000b\u00027!A\u0001\b\u0001B\u0001B\u0003%1$\u0001\u000bu_R\fG\u000eS1oI2,'\u000f\u00165sK\u0006$7\u000f\t\u0005\tu\u0001\u0011)\u0019!C\u0001w\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\"\u0011a\u00028fi^|'o[\u0005\u0003\u0003z\u0012aBU3rk\u0016\u001cHo\u00115b]:,G\u000e\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003=\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\t\u0005\u0004\u0018n\u001d\t\u0003\u000f\"k\u0011AA\u0005\u0003\u0013\n\u0011\u0011bS1gW\u0006\f\u0005/[:\t\u000b-\u0003A\u0011\u0001'\u0002\rqJg.\u001b;?)\u001diej\u0014)R%N\u0003\"a\u0012\u0001\t\u000biQ\u0005\u0019A\u000e\t\u000b\tR\u0005\u0019A\u000e\t\u000b\u0011R\u0005\u0019\u0001\u0014\t\u000bUR\u0005\u0019A\u000e\t\u000biR\u0005\u0019\u0001\u001f\t\u000b\u0015S\u0005\u0019\u0001$\t\u000bU\u0003A\u0011\u0001,\u0002\u0007I,h\u000eF\u0001X!\ta\u0002,\u0003\u0002Z;\t!QK\\5u\u0011\u0015Y\u0006\u0001\"\u0001W\u0003!\u0019\b.\u001e;e_^t\u0007")
public class KafkaRequestHandler
implements Runnable,
Logging {
    public final int kafka$server$KafkaRequestHandler$$id;
    public final int kafka$server$KafkaRequestHandler$$brokerId;
    private final Meter aggregateIdleMeter;
    private final int totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandler kafkaRequestHandler = this;
        synchronized (kafkaRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public int totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            ObjectRef req;
            try {
                req = new ObjectRef(null);
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception when handling request";
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                continue;
            }
            {
                while ((RequestChannel.Request)req.elem == null) {
                    long startSelectTime = SystemTime$.MODULE$.nanoseconds();
                    req.elem = this.requestChannel().receiveRequest(300L);
                    long idleTime = SystemTime$.MODULE$.nanoseconds() - startSelectTime;
                    this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads());
                }
                if ((RequestChannel.Request)req.elem == RequestChannel$.MODULE$.AllDone()) {
                    this.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaRequestHandler $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Kafka request handler %d on broker %d received shut down command")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$id), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$brokerId)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                ((RequestChannel.Request)req.elem).requestDequeueTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
                this.trace((Function0<String>)new Serializable(this, req){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaRequestHandler $outer;
                    private final ObjectRef req$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Kafka request handler %d on broker %d handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$id), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$brokerId), (RequestChannel.Request)this.req$1.elem}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.req$1 = req$1;
                    }
                });
                this.apis.handle((RequestChannel.Request)req.elem);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        this.requestChannel().sendRequest(RequestChannel$.MODULE$.AllDone());
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, int totalHandlerThreads, RequestChannel requestChannel, KafkaApis apis) {
        this.kafka$server$KafkaRequestHandler$$id = id;
        this.kafka$server$KafkaRequestHandler$$brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Request Handler ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)" on Broker ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"], ").toString());
    }
}

