/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.IOUtils;

public class HunspellStemFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String PARAM_STRICT_AFFIX_PARSING = "strictAffixParsing";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private HunspellDictionary dictionary;
    private boolean ignoreCase = false;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.assureMatchVersion();
        String dictionaryArg = (String)this.args.get(PARAM_DICTIONARY);
        if (dictionaryArg == null) {
            throw new IllegalArgumentException("Parameter dictionary is mandatory.");
        }
        String[] dictionaryFiles = ((String)this.args.get(PARAM_DICTIONARY)).split(",");
        String affixFile = (String)this.args.get(PARAM_AFFIX);
        String pic = (String)this.args.get(PARAM_IGNORE_CASE);
        if (pic != null) {
            if (pic.equalsIgnoreCase(TRUE)) {
                this.ignoreCase = true;
            } else if (pic.equalsIgnoreCase(FALSE)) {
                this.ignoreCase = false;
            } else {
                throw new IllegalArgumentException("Unknown value for ignoreCase: " + pic + ". Must be true or false");
            }
        }
        String strictAffixParsingParam = (String)this.args.get(PARAM_STRICT_AFFIX_PARSING);
        boolean strictAffixParsing = true;
        if (strictAffixParsingParam != null) {
            if (strictAffixParsingParam.equalsIgnoreCase(FALSE)) {
                strictAffixParsing = false;
            } else if (strictAffixParsingParam.equalsIgnoreCase(TRUE)) {
                strictAffixParsing = true;
            } else {
                throw new IllegalArgumentException("Unknown value for strictAffixParsing: " + strictAffixParsingParam + ". Must be true or false");
            }
        }
        InputStream affix = null;
        ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
        try {
            dictionaries = new ArrayList();
            for (String file : dictionaryFiles) {
                dictionaries.add(loader.openResource(file));
            }
            affix = loader.openResource(affixFile);
            this.dictionary = new HunspellDictionary(affix, dictionaries, this.luceneMatchVersion, this.ignoreCase, strictAffixParsing);
        }
        catch (ParseException e) {
            try {
                throw new IOException("Unable to load hunspell data! [dictionary=" + (String)this.args.get(PARAM_DICTIONARY) + ",affix=" + affixFile + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
                IOUtils.closeWhileHandlingException(dictionaries);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
        IOUtils.closeWhileHandlingException(dictionaries);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary);
    }
}

