/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.FileSetFormatter;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class AddFileSetsTask
implements ArchiverTask {
    private final List fileSets;
    private Logger logger;
    private MavenProject project;
    private MavenProject moduleProject;

    public AddFileSetsTask(List fileSets) {
        this.fileSets = fileSets;
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        File archiveBaseDir = configSource.getArchiveBaseDirectory();
        if (archiveBaseDir != null) {
            if (!archiveBaseDir.exists()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' does not exist");
            }
            if (!archiveBaseDir.isDirectory()) {
                throw new ArchiveCreationException("The archive base directory '" + archiveBaseDir.getAbsolutePath() + "' exists, but it is not a directory");
            }
        }
        Iterator i = this.fileSets.iterator();
        while (i.hasNext()) {
            FileSet fileSet = (FileSet)i.next();
            this.addFileSet(fileSet, archiver, configSource, archiveBaseDir);
        }
    }

    protected void addFileSet(FileSet fileSet, Archiver archiver, AssemblerConfigurationSource configSource, File archiveBaseDir) throws AssemblyFormattingException, ArchiveCreationException {
        this.checkLogger();
        FileSetFormatter fileSetFormatter = new FileSetFormatter(configSource, this.logger);
        if (this.project == null) {
            this.project = configSource.getProject();
        }
        File basedir = this.project.getBasedir();
        String destDirectory = fileSet.getOutputDirectory();
        if (destDirectory == null) {
            destDirectory = fileSet.getDirectory();
        }
        destDirectory = AssemblyFormatUtils.getOutputDirectory(destDirectory, configSource.getProject(), this.moduleProject, this.project, configSource.getFinalName(), configSource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("FileSet[" + destDirectory + "]" + " dir perms: " + Integer.toString(archiver.getOverrideDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getOverrideFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding()));
        }
        this.logger.debug("The archive base directory is '" + archiveBaseDir + "'");
        File fileSetDir = this.getFileSetDirectory(fileSet, basedir, archiveBaseDir);
        if (fileSetDir.exists()) {
            int fileMode;
            try {
                fileSetDir = fileSetFormatter.formatFileSetForAssembly(fileSetDir, fileSet);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error fixing file-set line endings for assembly: " + e.getMessage(), e);
            }
            this.logger.debug("Adding file-set from directory: '" + fileSetDir.getAbsolutePath() + "'\nassembly output directory is: '" + destDirectory + "'");
            AddDirectoryTask task = new AddDirectoryTask(fileSetDir);
            int dirMode = TypeConversionUtils.modeToInt(fileSet.getDirectoryMode(), this.logger);
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(fileSet.getFileMode(), this.logger)) != -1) {
                task.setFileMode(fileMode);
            }
            task.setUseDefaultExcludes(fileSet.isUseDefaultExcludes());
            List excludes = fileSet.getExcludes();
            excludes.add("**/*.filtered");
            task.setExcludes(excludes);
            task.setIncludes(fileSet.getIncludes());
            task.setOutputDirectory(destDirectory);
            task.execute(archiver, configSource);
        }
    }

    protected File getFileSetDirectory(FileSet fileSet, File basedir, File archiveBaseDir) throws ArchiveCreationException, AssemblyFormattingException {
        String sourceDirectory = fileSet.getDirectory();
        if (sourceDirectory == null || sourceDirectory.trim().length() < 1) {
            sourceDirectory = basedir.getAbsolutePath();
        }
        File fileSetDir = null;
        if (archiveBaseDir == null) {
            fileSetDir = new File(sourceDirectory);
            if (!fileSetDir.isAbsolute()) {
                fileSetDir = new File(basedir, sourceDirectory);
            }
        } else {
            fileSetDir = new File(archiveBaseDir, sourceDirectory);
        }
        return fileSetDir;
    }

    private void checkLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "AddFileSetsTask-internal");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getModuleProject() {
        return this.moduleProject;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }
}

