/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.assembly.archive.archiver.PrefixedArchivedFileSet;
import org.apache.maven.plugin.assembly.archive.archiver.PrefixedFileSet;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyProxyArchiver
implements Archiver {
    private static final String[] STR_TEMPLATE = new String[0];
    private final Archiver delegate;
    private String rootPrefix;
    private FileSelector[] selectors;
    private final ThreadLocal<Boolean> inPublicApi = new ThreadLocal();
    private final Logger logger;
    private final boolean dryRun;
    private boolean forced;
    private final Set<String> seenPaths = new HashSet<String>();
    private final String assemblyWorkPath;
    private boolean useJvmChmod;

    public AssemblyProxyArchiver(String rootPrefix, Archiver delegate, List<ContainerDescriptorHandler> containerDescriptorHandlers, List<FileSelector> extraSelectors, List<ArchiveFinalizer> extraFinalizers, File assemblyWorkDir, Logger logger, boolean dryRun) {
        this.rootPrefix = rootPrefix;
        this.delegate = delegate;
        this.assemblyWorkPath = assemblyWorkDir.getAbsolutePath().replace('\\', '/');
        this.logger = logger;
        this.dryRun = dryRun;
        if (!"".equals(rootPrefix) && !rootPrefix.endsWith("/")) {
            this.rootPrefix = this.rootPrefix + "/";
        }
        ArrayList<FileSelector> selectors = new ArrayList<FileSelector>();
        boolean isFinalizerEnabled = delegate instanceof FinalizerEnabled;
        if (containerDescriptorHandlers != null) {
            for (ContainerDescriptorHandler handler : containerDescriptorHandlers) {
                selectors.add(handler);
                if (!isFinalizerEnabled) continue;
                ((FinalizerEnabled)delegate).addArchiveFinalizer((ArchiveFinalizer)handler);
            }
        }
        if (extraSelectors != null) {
            for (FileSelector selector : extraSelectors) {
                selectors.add(selector);
            }
        }
        if (extraFinalizers != null && isFinalizerEnabled) {
            Iterator<ContainerDescriptorHandler> it = extraFinalizers.iterator();
            while (it.hasNext()) {
                ((FinalizerEnabled)delegate).addArchiveFinalizer((ArchiveFinalizer)it.next());
            }
        }
        if (!selectors.isEmpty()) {
            this.selectors = selectors.toArray(new FileSelector[selectors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivedFileSet(File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        String archiveKey = this.getArchiveKey(archiveFile, prefix);
        if (this.seenPaths.contains(archiveKey)) {
            this.warn("Archive: " + archiveFile + " has already been added. Skipping.");
            return;
        }
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet();
            fs.setArchive(archiveFile);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.addArchivedFileSet((ArchivedFileSet)fs);
                this.seenPaths.add(archiveKey);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    private String getArchiveKey(File archiveFile, String prefix) {
        return archiveFile.getAbsolutePath() + ":" + prefix;
    }

    private void debug(String message) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    private void warn(String message) {
        if (this.logger != null && this.logger.isWarnEnabled()) {
            this.logger.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivedFileSet(File archiveFile, String prefix) throws ArchiverException {
        String archiveKey = this.getArchiveKey(archiveFile, prefix);
        if (this.seenPaths.contains(archiveKey)) {
            this.warn("Archive: " + archiveFile + " has already been added. Skipping.");
            return;
        }
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet();
            fs.setArchive(archiveFile);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.addArchivedFileSet((ArchivedFileSet)fs);
                this.seenPaths.add(archiveKey);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        String archiveKey = this.getArchiveKey(archiveFile, "");
        if (this.seenPaths.contains(archiveKey)) {
            this.warn("Archive: " + archiveFile + " has already been added. Skipping.");
            return;
        }
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet();
            fs.setArchive(archiveFile);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.addArchivedFileSet((ArchivedFileSet)fs);
                this.seenPaths.add(archiveKey);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivedFileSet(File archiveFile) throws ArchiverException {
        String archiveKey = this.getArchiveKey(archiveFile, "");
        if (this.seenPaths.contains(archiveKey)) {
            this.warn("Archive: " + archiveFile + " has already been added. Skipping.");
            return;
        }
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet();
            fs.setArchive(archiveFile);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.addArchivedFileSet((ArchivedFileSet)fs);
                this.seenPaths.add(archiveKey);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.doAddFileSet((FileSet)fs);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.doAddFileSet((FileSet)fs);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.doAddFileSet((FileSet)fs);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectory(File directory) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.doAddFileSet((FileSet)fs);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        if (this.acceptFile(inputFile)) {
            this.inPublicApi.set(Boolean.TRUE);
            try {
                this.debug("Adding file: " + inputFile + " to archive location: " + this.rootPrefix + destFileName);
                if (this.dryRun) {
                    this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
                } else {
                    this.delegate.addFile(inputFile, this.rootPrefix + destFileName, permissions);
                }
            }
            finally {
                this.inPublicApi.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        if (this.acceptFile(inputFile)) {
            this.inPublicApi.set(Boolean.TRUE);
            try {
                this.debug("Adding file: " + inputFile + " to archive location: " + this.rootPrefix + destFileName);
                if (this.dryRun) {
                    this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
                } else {
                    this.delegate.addFile(inputFile, this.rootPrefix + destFileName);
                }
            }
            finally {
                this.inPublicApi.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createArchive() throws ArchiverException, IOException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.setForced(this.forced);
                this.delegate.createArchive();
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultDirectoryMode() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            int n = this.delegate.getDefaultDirectoryMode();
            return n;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultFileMode() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            int n = this.delegate.getDefaultFileMode();
            return n;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDestFile() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            File file = this.delegate.getDestFile();
            return file;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFiles() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            Map map = this.delegate.getFiles();
            return map;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIncludeEmptyDirs() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.getIncludeEmptyDirs();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isForced() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.isForced();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportingForced() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.isSupportingForced();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultDirectoryMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDefaultDirectoryMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFileMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDefaultFileMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestFile(File destFile) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDestFile(destFile);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForced(boolean forced) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.forced = forced;
            this.delegate.setForced(forced);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setIncludeEmptyDirs(includeEmptyDirs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    public void setDotFileDirectory(File dotFileDirectory) {
        throw new UnsupportedOperationException("Undocumented feature of plexus-archiver; this is not yet supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivedFileSet(ArchivedFileSet fileSet) throws ArchiverException {
        String archiveKey = this.getArchiveKey(fileSet.getArchive(), "");
        if (this.seenPaths.contains(archiveKey)) {
            this.warn("Archive: " + fileSet.getArchive() + " has already been added. Skipping.");
            return;
        }
        this.inPublicApi.set(Boolean.TRUE);
        try {
            PrefixedArchivedFileSet fs = new PrefixedArchivedFileSet(fileSet, this.rootPrefix, this.selectors);
            this.debug("Adding archived file-set in: " + fileSet.getArchive() + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.delegate.addArchivedFileSet((ArchivedFileSet)fs);
                this.seenPaths.add(archiveKey);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSet(FileSet fileSet) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            PrefixedFileSet fs = new PrefixedFileSet(fileSet, this.rootPrefix, this.selectors);
            this.debug("Adding file-set in: " + fileSet.getDirectory() + " to archive location: " + fs.getPrefix());
            if (this.dryRun) {
                this.debug("DRY RUN: Skipping delegated call to: " + this.getMethodName());
            } else {
                this.doAddFileSet(fs);
            }
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    private void doAddFileSet(FileSet fs) throws ArchiverException {
        String fsPath = fs.getDirectory().getAbsolutePath().replace('\\', '/');
        if (fsPath.equals(this.assemblyWorkPath)) {
            this.logger.debug("SKIPPING fileset with source directory matching assembly working-directory: " + fsPath);
            return;
        }
        if (this.assemblyWorkPath.startsWith(fsPath)) {
            ArrayList<String> newEx = new ArrayList<String>();
            if (fs.getExcludes() != null) {
                newEx.addAll(Arrays.asList(fs.getExcludes()));
            }
            String workDirExclude = this.assemblyWorkPath.substring(fsPath.length() + 1);
            this.logger.debug("Adding exclude for assembly working-directory: " + workDirExclude + "\nFile-Set source directory: " + fsPath);
            newEx.add(workDirExclude);
            ArrayList<String> newIn = new ArrayList<String>();
            if (fs.getIncludes() != null) {
                for (String include : fs.getIncludes()) {
                    if (include.startsWith(workDirExclude)) continue;
                    newIn.add(include);
                }
            }
            DefaultFileSet dfs = new DefaultFileSet();
            dfs.setCaseSensitive(fs.isCaseSensitive());
            dfs.setDirectory(fs.getDirectory());
            dfs.setExcludes(newEx.toArray(STR_TEMPLATE));
            dfs.setFileSelectors(fs.getFileSelectors());
            dfs.setIncludes(newIn.toArray(STR_TEMPLATE));
            dfs.setIncludingEmptyDirectories(fs.isIncludingEmptyDirectories());
            dfs.setPrefix(fs.getPrefix());
            dfs.setUsingDefaultExcludes(fs.isUsingDefaultExcludes());
            this.delegate.addFileSet((FileSet)dfs);
        } else {
            this.delegate.addFileSet(fs);
        }
    }

    private String getMethodName() {
        NullPointerException npe = new NullPointerException();
        StackTraceElement[] trace = npe.getStackTrace();
        StackTraceElement methodElement = trace[1];
        return methodElement.getMethodName() + " (archiver line: " + methodElement.getLineNumber() + ")";
    }

    private boolean acceptFile(File inputFile) throws ArchiverException {
        if (Boolean.TRUE != this.inPublicApi.get() && this.selectors != null) {
            DefaultFileInfo fileInfo = new DefaultFileInfo(inputFile);
            for (int i = 0; i < this.selectors.length; ++i) {
                FileSelector selector = this.selectors[i];
                try {
                    if (selector.isSelected((FileInfo)fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Error processing file: " + inputFile + " using selector: " + this.selectors[i], (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.addResource(resource, destFileName, permissions);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResources(PlexusIoResourceCollection resources) throws ArchiverException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.addResources(resources);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    public ResourceIterator getResources() throws ArchiverException {
        return this.delegate.getResources();
    }

    public String getDuplicateBehavior() {
        return this.delegate.getDuplicateBehavior();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDuplicateBehavior(String duplicate) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDuplicateBehavior(duplicate);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    public int getDirectoryMode() {
        return this.delegate.getDirectoryMode();
    }

    public int getFileMode() {
        return this.delegate.getFileMode();
    }

    public int getOverrideDirectoryMode() {
        return this.delegate.getOverrideDirectoryMode();
    }

    public int getOverrideFileMode() {
        return this.delegate.getOverrideFileMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectoryMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDirectoryMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setFileMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    public boolean isIgnorePermissions() {
        return this.delegate.isIgnorePermissions();
    }

    public void setIgnorePermissions(boolean ignorePermissions) {
        this.delegate.setIgnorePermissions(ignorePermissions);
    }

    private static final class DefaultFileInfo
    implements FileInfo {
        private final File inputFile;

        DefaultFileInfo(File inputFile) {
            this.inputFile = inputFile;
        }

        public InputStream getContents() throws IOException {
            return new FileInputStream(this.inputFile);
        }

        public String getName() {
            return this.inputFile.getName();
        }

        public boolean isDirectory() {
            return this.inputFile.isDirectory();
        }

        public boolean isFile() {
            return this.inputFile.isFile();
        }
    }
}

