/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugin.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugin.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AssemblyArchiverPhase.class, hint="dependency-sets")
public class DependencySetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase,
PhaseOrder {
    @Requirement
    private MavenProjectBuilder projectBuilder;
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement
    private DependencyResolver dependencyResolver;

    public DependencySetAssemblyPhase() {
    }

    public DependencySetAssemblyPhase(MavenProjectBuilder projectBuilder, DependencyResolver dependencyResolver, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.dependencyResolver = dependencyResolver;
        this.enableLogging(logger);
    }

    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        Map<DependencySet, Set<Artifact>> resolved = this.dependencyResolver.resolveDependencySets(assembly, configSource, assembly.getDependencySets());
        for (Map.Entry<DependencySet, Set<Artifact>> dependencySetSetEntry : resolved.entrySet()) {
            AddDependencySetsTask task = new AddDependencySetsTask(Collections.singletonList(dependencySetSetEntry.getKey()), dependencySetSetEntry.getValue(), configSource.getProject(), this.projectBuilder, this.getLogger());
            task.execute(archiver, configSource);
        }
    }

    @Override
    public int order() {
        return 40;
    }
}

