/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.filter;

import org.apache.maven.plugin.assembly.filter.AbstractLineAggregatingHandler;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

@Component(role=ContainerDescriptorHandler.class, hint="metaInf-spring", instantiationStrategy="per-lookup")
public class MetaInfSpringHandler
extends AbstractLineAggregatingHandler {
    private static final String SPRING_PATH_PREFIX = "META-INF/";

    @Override
    protected String getOutputPathPrefix(FileInfo fileInfo) {
        return SPRING_PATH_PREFIX;
    }

    @Override
    protected boolean fileMatches(FileInfo fileInfo) {
        String path = fileInfo.getName();
        String leftover = null;
        if (path.startsWith("/META-INF/spring.")) {
            leftover = path.substring("/META-INF/spring.".length());
        } else if (path.startsWith("META-INF/spring.")) {
            leftover = path.substring("META-INF/spring.".length() - 1);
        }
        return leftover != null && leftover.length() > 0;
    }
}

