/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clean;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clean.Cleaner;
import org.apache.maven.plugin.clean.Fileset;
import org.apache.maven.plugin.clean.GlobSelector;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", threadSafe=true)
public class CleanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File directory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true, required=true)
    private File testOutputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File reportDirectory;
    @Parameter(property="clean.verbose")
    private Boolean verbose;
    @Parameter
    private Fileset[] filesets;
    @Parameter(property="clean.followSymLinks", defaultValue="false")
    private boolean followSymLinks;
    @Parameter(property="clean.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.clean.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="maven.clean.retryOnError", defaultValue="true")
    private boolean retryOnError;
    @Parameter(property="clean.excludeDefaultDirectories", defaultValue="false")
    private boolean excludeDefaultDirectories;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        Cleaner cleaner = new Cleaner(this.getLog(), this.isVerbose());
        try {
            for (File directory : this.getDirectories()) {
                if (directory == null) continue;
                cleaner.delete(directory, null, this.followSymLinks, this.failOnError, this.retryOnError);
            }
            if (this.filesets != null) {
                for (Fileset fileset : this.filesets) {
                    if (fileset.getDirectory() == null) {
                        throw new MojoExecutionException("Missing base directory for " + fileset);
                    }
                    GlobSelector selector = new GlobSelector(fileset.getIncludes(), fileset.getExcludes(), fileset.isUseDefaultExcludes());
                    cleaner.delete(fileset.getDirectory(), selector, fileset.isFollowSymlinks(), this.failOnError, this.retryOnError);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean project: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isVerbose() {
        return this.verbose != null ? this.verbose.booleanValue() : this.getLog().isDebugEnabled();
    }

    private File[] getDirectories() {
        File[] directories = this.excludeDefaultDirectories ? new File[]{} : new File[]{this.directory, this.outputDirectory, this.testOutputDirectory, this.reportDirectory};
        return directories;
    }
}

