/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.compiler.module.JavaModuleDescriptor;
import org.apache.maven.plugin.compiler.module.ModuleInfoParser;
import org.codehaus.plexus.component.annotations.Component;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Component(role=ModuleInfoParser.class, hint="asm")
public class AsmModuleInfoParser
implements ModuleInfoParser {
    @Override
    public ModuleInfoParser.Type getType() {
        return ModuleInfoParser.Type.CLASS;
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(File modulePath) throws IOException {
        JavaModuleDescriptorWrapper wrapper = new JavaModuleDescriptorWrapper();
        InputStream in = this.getModuleInfoClass(modulePath);
        if (in != null) {
            ClassReader reader = new ClassReader(in);
            reader.accept(new ClassVisitor(393216){}, 0);
            in.close();
        } else {
            wrapper.builder = JavaModuleDescriptor.newAutomaticModule(null);
        }
        return wrapper.builder.build();
    }

    private InputStream getModuleInfoClass(File modulePath) throws FileNotFoundException, IOException {
        JarFile jarFile;
        JarEntry moduleInfo;
        InputStream in = modulePath.isDirectory() ? new FileInputStream(new File(modulePath, "module-info.class")) : ((moduleInfo = (jarFile = new JarFile(modulePath)).getJarEntry("/module-info.class")) != null ? jarFile.getInputStream(moduleInfo) : null);
        return in;
    }

    private static class JavaModuleDescriptorWrapper {
        private JavaModuleDescriptor.Builder builder;

        private JavaModuleDescriptorWrapper() {
        }
    }
}

