/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.util.SelectorUtils;

class ArtifactId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public ArtifactId(Dependency dependency) {
        this(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier());
    }

    public ArtifactId(Artifact artifact) {
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    public ArtifactId(String groupId, String artifactId, String type, String classifier) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.type = type != null ? type : "";
        this.classifier = classifier != null ? classifier : "";
    }

    public ArtifactId(String id) {
        String[] tokens = new String[]{};
        if (id != null && id.length() > 0) {
            tokens = id.split(":", -1);
        }
        this.groupId = tokens.length > 0 ? tokens[0] : "";
        this.artifactId = tokens.length > 1 ? tokens[1] : "*";
        String string = this.type = tokens.length > 3 ? tokens[2] : "*";
        this.classifier = tokens.length > 3 ? tokens[3] : (tokens.length > 2 ? tokens[2] : "*");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean matches(ArtifactId pattern) {
        if (pattern == null) {
            return false;
        }
        if (!this.match(this.getGroupId(), pattern.getGroupId())) {
            return false;
        }
        if (!this.match(this.getArtifactId(), pattern.getArtifactId())) {
            return false;
        }
        if (!this.match(this.getType(), pattern.getType())) {
            return false;
        }
        return this.match(this.getClassifier(), pattern.getClassifier());
    }

    private boolean match(String str, String pattern) {
        return SelectorUtils.match((String)pattern, (String)str);
    }
}

