/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.module.xdoc.XdocSinkFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.codehaus.plexus.i18n.I18N;

public class SiteMap {
    private String encoding;
    private I18N i18n;

    public SiteMap(String encoding, I18N i18n) {
        this.encoding = encoding;
        this.i18n = i18n;
    }

    public I18N getI18n() {
        return this.i18n;
    }

    public void setI18n(I18N i18n) {
        this.i18n = i18n;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(DecorationModel model, File targetDir, Locale locale) throws IOException {
        File outputDir = new File(targetDir, "xdoc");
        Sink sink = new XdocSinkFactory().createSink(outputDir, "sitemap.xml", this.encoding);
        try {
            this.extract(model, sink, locale);
        }
        finally {
            sink.close();
        }
    }

    private void extract(DecorationModel decoration, Sink sink, Locale locale) {
        sink.head();
        sink.title();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.section.title"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.description"));
        sink.paragraph_();
        Iterator it = decoration.getMenus().iterator();
        while (it.hasNext()) {
            Menu menu = (Menu)it.next();
            sink.section3();
            sink.sectionTitle3();
            sink.text(menu.getName());
            sink.sectionTitle3_();
            sink.horizontalRule();
            this.extractItems(menu.getItems(), sink);
            sink.section3_();
        }
        sink.section1_();
        sink.body_();
    }

    private void extractItems(List items, Sink sink) {
        if (items == null || items.isEmpty()) {
            return;
        }
        sink.list();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MenuItem item = (MenuItem)it.next();
            sink.listItem();
            sink.link(item.getHref());
            sink.text(item.getName());
            sink.link_();
            sink.listItem_();
            this.extractItems(item.getItems(), sink);
        }
        sink.list_();
    }
}

