/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.SiteMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class SiteJarMojo
extends SiteMojo {
    private String jarOutputDirectory;
    private String finalName;
    private MavenProjectHelper projectHelper;
    private boolean attach;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.outputDirectory.exists()) {
            super.execute();
        }
        try {
            File outputFile = this.createArchive(this.outputDirectory, this.finalName + "-" + this.getClassifier() + "." + this.getArtifactType());
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, this.getArtifactType(), this.getClassifier(), outputFile);
            } else {
                this.getLog().info((CharSequence)"NOT adding site jar to the list of attached artifacts.");
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while creating archive.", (Exception)e);
        }
    }

    protected String getArtifactType() {
        return "jar";
    }

    protected String getClassifier() {
        return "site";
    }

    private File createArchive(File siteDirectory, String jarFilename) throws ArchiverException, IOException {
        File siteJar = new File(this.jarOutputDirectory, jarFilename);
        if (siteJar.exists()) {
            siteJar.delete();
        }
        JarArchiver archiver = new JarArchiver();
        archiver.addDirectory(siteDirectory);
        archiver.setDestFile(siteJar);
        archiver.createArchive();
        return siteJar;
    }
}

