/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.SiteMap;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenReportExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="site", requiresDependencyResolution=ResolutionScope.TEST, requiresReports=true)
public class SiteMojo
extends AbstractSiteRenderingMojo {
    @Parameter(property="siteOutputDirectory", defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="generateReports", defaultValue="true")
    private boolean generateReports;
    @Parameter(property="generateSitemap", defaultValue="false")
    private boolean generateSitemap;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;
    @Parameter(property="maven.site.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site generation");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"executing Site Mojo");
        }
        List<Object> reports = this.generateReports ? this.getReports() : Collections.emptyList();
        try {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            Locale defaultLocale = (Locale)localesList.get(0);
            Locale.setDefault(defaultLocale);
            for (Locale locale : localesList) {
                this.renderLocale(locale, reports);
            }
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Error during page generation", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private void renderLocale(Locale locale, List<MavenReportExecution> reports) throws IOException, RendererException, MojoFailureException, MojoExecutionException {
        SiteRenderingContext context = this.createSiteRenderingContext(locale);
        context.setInputEncoding(this.getInputEncoding());
        context.setOutputEncoding(this.getOutputEncoding());
        context.setValidate(this.validate);
        if (this.validate) {
            this.getLog().info((CharSequence)"Validation is switched on, xml input documents will be validated!");
        }
        Map documents = this.locateDocuments(context, reports, locale);
        File outputDir = this.getOutputDirectory(locale);
        for (MavenReportExecution mavenReportExecution : reports) {
            MavenReport report = mavenReportExecution.getMavenReport();
            report.setReportOutputDirectory(outputDir);
        }
        this.siteRenderer.render(documents.values(), context, outputDir);
        if (this.generateSitemap) {
            this.getLog().info((CharSequence)"Generating Sitemap.");
            new SiteMap(this.getOutputEncoding(), this.i18n).generate(context.getDecoration(), this.generatedSiteDirectory, locale);
        }
        context.getSiteDirectories().clear();
        context.addSiteDirectory(this.generatedSiteDirectory);
        documents = this.siteRenderer.locateDocumentFiles(context);
        this.siteRenderer.render(documents.values(), context, outputDir);
    }

    private File getOutputDirectory(Locale locale) {
        File file = locale.getLanguage().equals(Locale.getDefault().getLanguage()) ? this.outputDirectory : new File(this.outputDirectory, locale.getLanguage());
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

