/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.IdentifiedScm;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRewritePomsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private String pomSuffix;
    private String ls = ReleaseUtil.LS;

    public void setLs(String ls) {
        this.ls = ls;
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, releaseEnvironment, reactorProjects, false, result);
        result.setResultCode(0);
        return result;
    }

    private void transform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        for (MavenProject project : reactorProjects) {
            this.logInfo(result, "Transforming '" + project.getName() + "'...");
            this.transformProject(project, releaseDescriptor, releaseEnvironment, reactorProjects, simulate, result);
        }
    }

    private void transformProject(MavenProject project, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        ScmProvider provider;
        ScmRepository scmRepository;
        Document document;
        String intro = null;
        String outtro = null;
        try {
            String content = ReleaseUtil.readXmlFile(ReleaseUtil.getStandardPom(project), this.ls);
            content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
            content = content.replaceAll("(\\s{2,}|[^\\s])/>", "$1 />");
            SAXBuilder builder = new SAXBuilder();
            document = builder.build((Reader)new StringReader(content));
            this.normaliseLineEndings(document);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(this.ls);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            int index = content.indexOf(w.toString());
            if (index >= 0) {
                intro = content.substring(0, index);
                outtro = content.substring(index + w.toString().length());
            } else {
                String SPACE = "\\s++";
                String XML = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String INTSUB = "\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]";
                String DOCTYPE = "<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>";
                String PI = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String COMMENT = "<!--(?:[^-]|(?:-[^-]))*+-->";
                String INTRO = "(?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String OUTRO = "(?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String POM = "(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)";
                Matcher matcher = Pattern.compile("(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)").matcher(content);
                if (matcher.matches()) {
                    intro = matcher.group(1);
                    outtro = matcher.group(matcher.groupCount());
                }
            }
        }
        catch (JDOMException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        try {
            scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        this.transformDocument(project, document.getRootElement(), releaseDescriptor, reactorProjects, scmRepository, result, simulate);
        File pomFile = ReleaseUtil.getStandardPom(project);
        if (simulate) {
            File outputFile = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.pomSuffix);
            this.writePom(outputFile, document, releaseDescriptor, project.getModelVersion(), intro, outtro);
        } else {
            this.writePom(pomFile, document, releaseDescriptor, project.getModelVersion(), intro, outtro, scmRepository, provider);
        }
    }

    private void normaliseLineEndings(Document document) {
        Comment c;
        Iterator i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            c = (Comment)i.next();
            c.setText(ReleaseUtil.normalizeLineEndings(c.getText(), this.ls));
        }
        i = document.getDescendants((Filter)new ContentFilter(2));
        while (i.hasNext()) {
            c = (CDATA)i.next();
            c.setText(ReleaseUtil.normalizeLineEndings(c.getText(), this.ls));
        }
    }

    private void transformDocument(MavenProject project, Element rootElement, ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects, ScmRepository scmRepository, ReleaseResult result, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        String commonBasedir;
        Namespace namespace = rootElement.getNamespace();
        Map<String, String> mappedVersions = this.getNextVersionMap(releaseDescriptor);
        Map<String, String> originalVersions = this.getOriginalVersionMap(releaseDescriptor, reactorProjects, simulate);
        Map resolvedSnapshotDependencies = releaseDescriptor.getResolvedSnapshotDependencies();
        Model model = project.getModel();
        Element properties = rootElement.getChild("properties", namespace);
        String parentVersion = this.rewriteParent(project, rootElement, namespace, mappedVersions, resolvedSnapshotDependencies, originalVersions);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        this.rewriteVersion(rootElement, namespace, mappedVersions, projectId, project, parentVersion);
        ArrayList<Element> roots = new ArrayList<Element>();
        roots.add(rootElement);
        roots.addAll(this.getChildren(rootElement, "profiles", "profile"));
        for (Element root : roots) {
            this.rewriteArtifactVersions(this.getChildren(root, "dependencies", "dependency"), mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
            this.rewriteArtifactVersions(this.getChildren(root, "dependencyManagement", "dependencies", "dependency"), mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
            this.rewriteArtifactVersions(this.getChildren(root, "build", "extensions", "extension"), mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
            ArrayList<Element> pluginElements = new ArrayList<Element>();
            pluginElements.addAll(this.getChildren(root, "build", "plugins", "plugin"));
            pluginElements.addAll(this.getChildren(root, "build", "pluginManagement", "plugins", "plugin"));
            this.rewriteArtifactVersions(pluginElements, mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
            for (Element pluginElement : pluginElements) {
                this.rewriteArtifactVersions(this.getChildren(pluginElement, "dependencies", "dependency"), mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
            }
            this.rewriteArtifactVersions(this.getChildren(root, "reporting", "plugins", "plugin"), mappedVersions, resolvedSnapshotDependencies, originalVersions, model, properties, result, releaseDescriptor);
        }
        try {
            commonBasedir = ReleaseUtil.getCommonBasedir(reactorProjects);
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Exception occurred while calculating common basedir: " + e.getMessage(), e);
        }
        this.transformScm(project, rootElement, namespace, releaseDescriptor, projectId, scmRepository, result, commonBasedir);
    }

    private List<Element> getChildren(Element root, String ... names) {
        Element parent = root;
        for (int i = 0; i < names.length - 1 && parent != null; parent = parent.getChild(names[i], parent.getNamespace()), ++i) {
        }
        if (parent == null) {
            return Collections.emptyList();
        }
        return parent.getChildren(names[names.length - 1], parent.getNamespace());
    }

    private void rewriteValue(Element element, String value) {
        Text text = null;
        if (element.getContent() != null) {
            Iterator it = element.getContent().iterator();
            while (it.hasNext()) {
                Object content = it.next();
                if (!(content instanceof Text) || ((Text)content).getTextTrim().length() <= 0) continue;
                text = (Text)content;
                while (it.hasNext() && (content = it.next()) instanceof Text) {
                    text.append((Text)content);
                    it.remove();
                }
                break block0;
            }
        }
        if (text == null) {
            element.addContent(value);
        } else {
            String chars = text.getText();
            String trimmed = text.getTextTrim();
            int idx = chars.indexOf(trimmed);
            String leadingWhitespace = chars.substring(0, idx);
            String trailingWhitespace = chars.substring(idx + trimmed.length());
            text.setText(leadingWhitespace + value + trailingWhitespace);
        }
    }

    private void rewriteVersion(Element rootElement, Namespace namespace, Map<String, String> mappedVersions, String projectId, MavenProject project, String parentVersion) throws ReleaseFailureException {
        Element versionElement = rootElement.getChild("version", namespace);
        String version = mappedVersions.get(projectId);
        if (version == null) {
            throw new ReleaseFailureException("Version for '" + project.getName() + "' was not mapped");
        }
        if (versionElement == null) {
            if (!version.equals(parentVersion)) {
                Element artifactIdElement = rootElement.getChild("artifactId", namespace);
                int index = rootElement.indexOf((Content)artifactIdElement);
                versionElement = new Element("version", namespace);
                versionElement.setText(version);
                rootElement.addContent(index + 1, (Content)new Text("\n  "));
                rootElement.addContent(index + 2, (Content)versionElement);
            }
        } else {
            this.rewriteValue(versionElement, version);
        }
    }

    private String rewriteParent(MavenProject project, Element rootElement, Namespace namespace, Map<String, String> mappedVersions, Map<String, Map<String, String>> resolvedSnapshotDependencies, Map<String, String> originalVersions) throws ReleaseFailureException {
        String parentVersion = null;
        if (project.hasParent()) {
            Element parentElement = rootElement.getChild("parent", namespace);
            Element versionElement = parentElement.getChild("version", namespace);
            MavenProject parent = project.getParent();
            String key = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
            parentVersion = mappedVersions.get(key);
            if (parentVersion == null) {
                parentVersion = this.getResolvedSnapshotVersion(key, resolvedSnapshotDependencies);
            }
            if (parentVersion == null) {
                if (parent.getVersion().equals(originalVersions.get(key))) {
                    throw new ReleaseFailureException("Version for parent '" + parent.getName() + "' was not mapped");
                }
            } else {
                this.rewriteValue(versionElement, parentVersion);
            }
        }
        return parentVersion;
    }

    private void rewriteArtifactVersions(Collection<Element> elements, Map<String, String> mappedVersions, Map<String, Map<String, String>> resolvedSnapshotDependencies, Map<String, String> originalVersions, Model projectModel, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        if (elements == null) {
            return;
        }
        String projectId = ArtifactUtils.versionlessKey((String)projectModel.getGroupId(), (String)projectModel.getArtifactId());
        for (Element element : elements) {
            Element versionElement = element.getChild("version", element.getNamespace());
            if (versionElement == null) continue;
            String rawVersion = versionElement.getTextTrim();
            Element groupIdElement = element.getChild("groupId", element.getNamespace());
            if (groupIdElement == null) {
                if (!"plugin".equals(element.getName())) continue;
                groupIdElement = new Element("groupId", element.getNamespace());
                groupIdElement.setText("org.apache.maven.plugins");
            }
            String groupId = this.interpolate(groupIdElement.getTextTrim(), projectModel);
            Element artifactIdElement = element.getChild("artifactId", element.getNamespace());
            if (artifactIdElement == null) continue;
            String artifactId = this.interpolate(artifactIdElement.getTextTrim(), projectModel);
            String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            String resolvedSnapshotVersion = this.getResolvedSnapshotVersion(key, resolvedSnapshotDependencies);
            String mappedVersion = mappedVersions.get(key);
            String originalVersion = originalVersions.get(key);
            if (originalVersion == null) {
                originalVersion = this.getOriginalResolvedSnapshotVersion(key, resolvedSnapshotDependencies);
            }
            if (mappedVersion != null && mappedVersion.endsWith("SNAPSHOT") && !rawVersion.endsWith("SNAPSHOT") && !releaseDescriptor.isUpdateDependencies()) continue;
            if (mappedVersion != null) {
                if (rawVersion.equals(originalVersion)) {
                    this.logInfo(result, "  Updating " + artifactId + " to " + mappedVersion);
                    this.rewriteValue(versionElement, mappedVersion);
                    continue;
                }
                if (!rawVersion.matches("\\$\\{.+\\}")) continue;
                String expression = rawVersion.substring(2, rawVersion.length() - 1);
                if (expression.startsWith("project.") || expression.startsWith("pom.") || "version".equals(expression)) {
                    if (!mappedVersion.equals(mappedVersions.get(projectId))) {
                        this.logInfo(result, "  Updating " + artifactId + " to " + mappedVersion);
                        this.rewriteValue(versionElement, mappedVersion);
                        continue;
                    }
                    this.logInfo(result, "  Ignoring artifact version update for expression " + rawVersion);
                    continue;
                }
                if (properties == null) continue;
                Element property = properties.getChild(expression, properties.getNamespace());
                if (property != null) {
                    String propertyValue = property.getTextTrim();
                    if (propertyValue.equals(originalVersion)) {
                        this.logInfo(result, "  Updating " + rawVersion + " to " + mappedVersion);
                        this.rewriteValue(property, mappedVersion);
                        continue;
                    }
                    if (mappedVersion.equals(propertyValue)) {
                        this.logInfo(result, "  Ignoring artifact version update for expression " + rawVersion + " because it is already updated");
                        continue;
                    }
                    if (mappedVersion.equals(rawVersion)) continue;
                    if (mappedVersion.matches("\\$\\{project.+\\}") || mappedVersion.matches("\\$\\{pom.+\\}") || "${version}".equals(mappedVersion)) {
                        this.logInfo(result, "  Ignoring artifact version update for expression " + mappedVersion);
                        continue;
                    }
                    throw new ReleaseFailureException("The artifact (" + key + ") requires a " + "different version (" + mappedVersion + ") than what is found (" + propertyValue + ") for the expression (" + expression + ") in the " + "project (" + projectId + ").");
                }
                throw new ReleaseFailureException("The version could not be updated: " + rawVersion);
            }
            if (resolvedSnapshotVersion == null) continue;
            this.logInfo(result, "  Updating " + artifactId + " to " + resolvedSnapshotVersion);
            this.rewriteValue(versionElement, resolvedSnapshotVersion);
        }
    }

    private String interpolate(String value, Model model) throws ReleaseExecutionException {
        if (value != null && value.contains("${")) {
            StringSearchInterpolator interpolator = new StringSearchInterpolator();
            List<String> pomPrefixes = Arrays.asList("pom.", "project.");
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(pomPrefixes, (Object)model, false));
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)model.getProperties()));
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)model));
            try {
                value = interpolator.interpolate(value, (RecursionInterceptor)new PrefixAwareRecursionInterceptor(pomPrefixes));
            }
            catch (InterpolationException e) {
                throw new ReleaseExecutionException("Failed to interpolate " + value + " for project " + model.getId(), e);
            }
        }
        return value;
    }

    private void writePom(File pomFile, Document document, ReleaseDescriptor releaseDescriptor, String modelVersion, String intro, String outtro, ScmRepository repository, ScmProvider provider) throws ReleaseExecutionException, ReleaseScmCommandException {
        try {
            EditScmResult result;
            if ((releaseDescriptor.isScmUseEditMode() || provider.requiresEditMode()) && !(result = provider.edit(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), pomFile))).isSuccess()) {
                throw new ReleaseScmCommandException("Unable to enable editing on the POM", (ScmResult)result);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred enabling edit mode: " + e.getMessage(), e);
        }
        this.writePom(pomFile, document, releaseDescriptor, modelVersion, intro, outtro);
    }

    private void writePom(File pomFile, Document document, ReleaseDescriptor releaseDescriptor, String modelVersion, String intro, String outtro) throws ReleaseExecutionException {
        Element rootElement = document.getRootElement();
        if (releaseDescriptor.isAddSchema()) {
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)("http://maven.apache.org/POM/" + modelVersion));
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/" + modelVersion + " http://maven.apache.org/maven-v" + modelVersion.replace('.', '_') + ".xsd", xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)pomFile);
            if (intro != null) {
                writer.write(intro);
            }
            Format format = Format.getRawFormat();
            format.setLineSeparator(this.ls);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)writer);
            if (outtro != null) {
                writer.write(outtro);
            }
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error writing POM: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, releaseEnvironment, reactorProjects, true, result);
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult clean(List<MavenProject> reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        super.clean(reactorProjects);
        if (reactorProjects != null) {
            for (MavenProject project : reactorProjects) {
                File file;
                File pomFile = ReleaseUtil.getStandardPom(project);
                if (pomFile == null || !(file = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.pomSuffix)).exists()) continue;
                file.delete();
            }
        }
        result.setResultCode(0);
        return result;
    }

    protected abstract String getResolvedSnapshotVersion(String var1, Map<String, Map<String, String>> var2);

    protected abstract Map<String, String> getOriginalVersionMap(ReleaseDescriptor var1, List<MavenProject> var2, boolean var3);

    protected abstract Map<String, String> getNextVersionMap(ReleaseDescriptor var1);

    protected abstract void transformScm(MavenProject var1, Element var2, Namespace var3, ReleaseDescriptor var4, String var5, ScmRepository var6, ReleaseResult var7, String var8) throws ReleaseExecutionException;

    protected String getOriginalResolvedSnapshotVersion(String artifactVersionlessKey, Map<String, Map<String, String>> resolvedSnapshots) {
        Map<String, String> versionsMap = resolvedSnapshots.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return versionsMap.get("original");
        }
        return null;
    }

    protected Element rewriteElement(String name, String value, Element root, Namespace namespace) {
        Element tagElement = root.getChild(name, namespace);
        if (tagElement != null) {
            if (value != null) {
                this.rewriteValue(tagElement, value);
            } else {
                int index = root.indexOf((Content)tagElement);
                root.removeContent(index);
                for (int i = index - 1; i >= 0 && root.getContent(i) instanceof Text; --i) {
                    root.removeContent(i);
                }
            }
        } else if (value != null) {
            Element element = new Element(name, namespace);
            element.setText(value);
            root.addContent("  ").addContent((Content)element).addContent("\n  ");
            tagElement = element;
        }
        return tagElement;
    }

    protected Scm buildScm(MavenProject project) {
        IdentifiedScm scm;
        if (project.getOriginalModel().getScm() == null) {
            scm = null;
        } else {
            scm = new IdentifiedScm();
            scm.setConnection(project.getOriginalModel().getScm().getConnection());
            scm.setDeveloperConnection(project.getOriginalModel().getScm().getDeveloperConnection());
            scm.setTag(project.getOriginalModel().getScm().getTag());
            scm.setUrl(project.getOriginalModel().getScm().getUrl());
            scm.setId(project.getProperties().getProperty("project.scm.id"));
        }
        return scm;
    }
}

