/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remove;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.remove.GitRemoveConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRemoveCommand
extends AbstractRemoveCommand
implements GitCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitRemoveConsumer consumer;
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        Commandline cl = GitRemoveCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        int exitCode = GitCommandLineUtils.execute(cl, consumer = new GitRemoveConsumer(this.getLogger()), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new RemoveScmResult(cl.toString(), "The git command failed.", stderr.getOutput(), false);
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovedFiles());
    }

    public static Commandline createCommandLine(File workingDirectory, List<File> files) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "rm");
        for (File file : files) {
            if (!file.isDirectory()) continue;
            cl.createArg().setValue("-r");
            break;
        }
        GitCommandLineUtils.addTarget(cl, files);
        return cl;
    }
}

