/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.apache.commons.lang.math;

import org.apache.maven.surefire.shade.org.apache.commons.lang.math.NumberUtils;

public abstract class Range {
    public boolean containsDouble(double value) {
        int compareMin = NumberUtils.compare(this.getMinimumDouble(), value);
        int compareMax = NumberUtils.compare(this.getMaximumDouble(), value);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean containsDouble(Number value) {
        if (value == null) {
            return false;
        }
        return this.containsDouble(value.doubleValue());
    }

    public boolean containsFloat(float value) {
        int compareMin = NumberUtils.compare(this.getMinimumFloat(), value);
        int compareMax = NumberUtils.compare(this.getMaximumFloat(), value);
        return compareMin <= 0 && compareMax >= 0;
    }

    public boolean containsFloat(Number value) {
        if (value == null) {
            return false;
        }
        return this.containsFloat(value.floatValue());
    }

    public boolean containsInteger(int value) {
        return value >= this.getMinimumInteger() && value <= this.getMaximumInteger();
    }

    public boolean containsInteger(Number value) {
        if (value == null) {
            return false;
        }
        return this.containsInteger(value.intValue());
    }

    public boolean containsLong(long value) {
        return value >= this.getMinimumLong() && value <= this.getMaximumLong();
    }

    public boolean containsLong(Number value) {
        if (value == null) {
            return false;
        }
        return this.containsLong(value.longValue());
    }

    public abstract boolean containsNumber(Number var1);

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsNumber(range.getMinimumNumber()) && this.containsNumber(range.getMaximumNumber());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)obj;
        return this.getMinimumNumber().equals(range.getMinimumNumber()) && this.getMaximumNumber().equals(range.getMaximumNumber());
    }

    public double getMaximumDouble() {
        return this.getMaximumNumber().doubleValue();
    }

    public float getMaximumFloat() {
        return this.getMaximumNumber().floatValue();
    }

    public int getMaximumInteger() {
        return this.getMaximumNumber().intValue();
    }

    public long getMaximumLong() {
        return this.getMaximumNumber().longValue();
    }

    public abstract Number getMaximumNumber();

    public double getMinimumDouble() {
        return this.getMinimumNumber().doubleValue();
    }

    public float getMinimumFloat() {
        return this.getMinimumNumber().floatValue();
    }

    public int getMinimumInteger() {
        return this.getMinimumNumber().intValue();
    }

    public long getMinimumLong() {
        return this.getMinimumNumber().longValue();
    }

    public abstract Number getMinimumNumber();

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + this.getMinimumNumber().hashCode();
        result = 37 * result + this.getMaximumNumber().hashCode();
        return result;
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsNumber(this.getMinimumNumber()) || range.containsNumber(this.getMaximumNumber()) || this.containsNumber(range.getMinimumNumber());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append("Range[");
        buf.append(this.getMinimumNumber());
        buf.append(',');
        buf.append(this.getMaximumNumber());
        buf.append(']');
        return buf.toString();
    }
}

