/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.constant.Paren;

public final class SQLUtil {
    public static Number getExactlyNumber(String value, int radix) {
        try {
            return SQLUtil.getBigInteger(value, radix);
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    private static Number getBigInteger(String value, int radix) {
        BigInteger result = new BigInteger(value, radix);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static String getExactlyExpression(String value) {
        return Strings.isNullOrEmpty((String)value) ? value : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getExpressionWithoutOutsideParentheses(String value) {
        int parenthesesOffset = SQLUtil.getParenthesesOffset(value);
        return 0 == parenthesesOffset ? value : value.substring(parenthesesOffset, value.length() - parenthesesOffset);
    }

    private static int getParenthesesOffset(String value) {
        int result = 0;
        while (Paren.PARENTHESES.getLeftParen() == value.charAt(result)) {
            ++result;
        }
        return result;
    }

    @Generated
    private SQLUtil() {
    }
}

