/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.ActionBean;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthDecisionStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.saml.bean.SubjectLocalityBean;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSAMLCallbackHandler
implements CallbackHandler {
    protected String subjectName = null;
    protected String subjectQualifier = null;
    protected String confirmationMethod = null;
    protected X509Certificate[] certs;
    protected Statement statement = Statement.AUTHN;
    protected KeyInfoBean.CERT_IDENTIFIER certIdentifier = KeyInfoBean.CERT_IDENTIFIER.X509_CERT;
    protected byte[] ephemeralKey = null;
    protected String issuer = null;
    protected String subjectNameIDFormat = null;
    protected String subjectLocalityIpAddress = null;
    protected String subjectLocalityDnsAddress = null;
    protected DateTime sessionNotOnOrAfter = null;
    protected String resource = null;
    protected List<Object> customAttributeValues = null;
    protected ConditionsBean conditions = null;
    protected SubjectConfirmationDataBean subjectConfirmationData = null;

    public void setSubjectConfirmationData(SubjectConfirmationDataBean subjectConfirmationData) {
        this.subjectConfirmationData = subjectConfirmationData;
    }

    public void setConditions(ConditionsBean conditionsBean) {
        this.conditions = conditionsBean;
    }

    public void setConfirmationMethod(String confMethod) {
        this.confirmationMethod = confMethod;
    }

    public void setSessionNotOnOrAfter(DateTime sessionNotOnOrAfter) {
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER certIdentifier) {
        this.certIdentifier = certIdentifier;
    }

    public void setCerts(X509Certificate[] certs) {
        this.certs = certs;
    }

    public byte[] getEphemeralKey() {
        return this.ephemeralKey;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
    }

    public void setSubjectLocality(String ipAddress, String dnsAddress) {
        this.subjectLocalityIpAddress = ipAddress;
        this.subjectLocalityDnsAddress = dnsAddress;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setCustomAttributeValues(List<Object> customAttributeValues) {
        this.customAttributeValues = customAttributeValues;
    }

    protected void createAndSetStatement(SubjectBean subjectBean, SAMLCallback callback) {
        if (this.statement == Statement.AUTHN) {
            AuthenticationStatementBean authBean = new AuthenticationStatementBean();
            if (subjectBean != null) {
                authBean.setSubject(subjectBean);
            }
            if (this.subjectLocalityIpAddress != null || this.subjectLocalityDnsAddress != null) {
                SubjectLocalityBean subjectLocality = new SubjectLocalityBean();
                subjectLocality.setIpAddress(this.subjectLocalityIpAddress);
                subjectLocality.setDnsAddress(this.subjectLocalityDnsAddress);
                authBean.setSubjectLocality(subjectLocality);
            }
            authBean.setAuthenticationMethod("Password");
            authBean.setSessionNotOnOrAfter(this.sessionNotOnOrAfter);
            callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        } else if (this.statement == Statement.ATTR) {
            AttributeStatementBean attrBean = new AttributeStatementBean();
            AttributeBean attributeBean = new AttributeBean();
            if (subjectBean != null) {
                attrBean.setSubject(subjectBean);
                attributeBean.setSimpleName("role");
                attributeBean.setQualifiedName("http://custom-ns");
            } else {
                attributeBean.setQualifiedName("role");
            }
            if (this.customAttributeValues != null) {
                attributeBean.setAttributeValues(this.customAttributeValues);
            } else {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("user");
                attributeBean.setAttributeValues(attributes);
            }
            attrBean.setSamlAttributes(Collections.singletonList(attributeBean));
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        } else {
            AuthDecisionStatementBean authzBean = new AuthDecisionStatementBean();
            if (subjectBean != null) {
                authzBean.setSubject(subjectBean);
            }
            ActionBean actionBean = new ActionBean();
            actionBean.setContents("Read");
            authzBean.setActions(Collections.singletonList(actionBean));
            authzBean.setResource("endpoint");
            authzBean.setDecision(AuthDecisionStatementBean.Decision.PERMIT);
            authzBean.setResource(this.resource);
            callback.setAuthDecisionStatementData(Collections.singletonList(authzBean));
        }
    }

    protected KeyInfoBean createKeyInfo() throws Exception {
        KeyInfoBean keyInfo = new KeyInfoBean();
        if (this.statement == Statement.AUTHN) {
            keyInfo.setCertificate(this.certs[0]);
            keyInfo.setCertIdentifer(this.certIdentifier);
        } else if (this.statement == Statement.ATTR) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
            encrKey.setKeyIdentifierType(2);
            encrKey.setUseThisCert(this.certs[0]);
            encrKey.prepare(doc, null);
            this.ephemeralKey = encrKey.getEphemeralKey();
            Element encryptedKeyElement = encrKey.getEncryptedKeyElement();
            Element keyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
            keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            keyInfoElement.appendChild(encryptedKeyElement);
            keyInfo.setElement(keyInfoElement);
        }
        return keyInfo;
    }

    public static enum Statement {
        AUTHN,
        ATTR,
        AUTHZ;

    }
}

