/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;

public class CombinedCallbackHandler
implements CallbackHandler {
    private final CallbackHandler secretCallbackHandler;
    private final CallbackHandler keystoreCallbackHandler;

    public CombinedCallbackHandler(CallbackHandler secretCallbackHandler, CallbackHandler keystoreCallbackHandler) {
        this.secretCallbackHandler = secretCallbackHandler;
        this.keystoreCallbackHandler = keystoreCallbackHandler;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (pc.getUsage() == 9 || pc.getUsage() == 6) {
                    this.secretCallbackHandler.handle(callbacks);
                    continue;
                }
                this.keystoreCallbackHandler.handle(callbacks);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

