/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Subject;

public class CustomSamlAssertionValidator
extends SamlAssertionValidator {
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        Credential returnedCredential = super.validate(credential, data);
        SamlAssertionWrapper samlAssertion = credential.getSamlAssertion();
        if (!"www.example.com".equals(samlAssertion.getIssuerString())) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        if (samlAssertion.getSaml1() != null) {
            Assertion saml1Assertion = samlAssertion.getSaml1();
            Subject samlSubject = null;
            for (Statement stmt : saml1Assertion.getStatements()) {
                if (stmt instanceof AttributeStatement) {
                    AttributeStatement attrStmt = (AttributeStatement)stmt;
                    samlSubject = attrStmt.getSubject();
                    break;
                }
                if (stmt instanceof AuthenticationStatement) {
                    AuthenticationStatement authStmt = (AuthenticationStatement)stmt;
                    samlSubject = authStmt.getSubject();
                    break;
                }
                AuthorizationDecisionStatement authzStmt = (AuthorizationDecisionStatement)stmt;
                samlSubject = authzStmt.getSubject();
            }
            if (samlSubject == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
            }
            String nameIdentifier = samlSubject.getNameIdentifier().getNameIdentifier();
            if (nameIdentifier == null || !nameIdentifier.contains("uid=joe")) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
        } else {
            org.opensaml.saml2.core.Assertion saml2Assertion = samlAssertion.getSaml2();
            org.opensaml.saml2.core.Subject subject = saml2Assertion.getSubject();
            String nameIdentifier = subject.getNameID().getValue();
            if (nameIdentifier == null || !nameIdentifier.contains("uid=joe")) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
        }
        return returnedCredential;
    }
}

