/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

public class SAML1AuthnHOKHandler
implements CallbackHandler {
    private String subjectName = "uid=joe,ou=people,ou=saml-demo,o=example.com";
    private String subjectQualifier = "www.example.com";
    private X509Certificate[] certs;

    public SAML1AuthnHOKHandler() throws WSSecurityException {
        Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        this.certs = crypto.getX509Certificates(cryptoType);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof SAMLCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            callback.setSamlVersion(SAMLVersion.VERSION_11);
            SubjectBean subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
            KeyInfoBean keyInfo = new KeyInfoBean();
            keyInfo.setCertificate(this.certs[0]);
            subjectBean.setKeyInfo(keyInfo);
            AuthenticationStatementBean authBean = new AuthenticationStatementBean();
            authBean.setSubject(subjectBean);
            authBean.setAuthenticationMethod("Password");
            callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        }
    }
}

